/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;


public class AddElementCometLogEntry extends CometLogEntry {

	private GraphicElementBean bean;
	private String parentId;
	
	public AddElementCometLogEntry(){
		super();
	}
	
	public AddElementCometLogEntry(String eiId, String modelId, GraphicElementBean bean, String parentId){
		super(eiId,modelId);
		this.bean = bean;
		this.parentId = parentId;
	}
	
	
	@Override
	public boolean isSimilar(CometLogEntry other) {
		if(other instanceof AddElementCometLogEntry && checkIds(other)){
			AddElementCometLogEntry e = (AddElementCometLogEntry) other;
			
			//TODO remove trace
			System.out.println(bean.getX_left()+"  "+e.bean.getX_left());
			System.out.println(bean.getY_left()+"  "+e.bean.getY_left());
			
			return bean.getId().equals(e.bean.getId()) && 
					(parentId==null ? e.getParentId()==null : parentId.equals(e.getParentId()));
			//TODO complete
		}
		return false;
	}
	

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public GraphicElementBean getBean() {
		return bean;
	}

	public void setBean(GraphicElementBean bean) {
		this.bean = bean;
	}

	
}
