/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.editor.CometStandAloneBPMNEditor;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DiagramComponent;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;

public class CollaborationComponent extends DiagramComponent {

	private Collaboration collab;
	private CometStandAloneBPMNEditor cometEditor;
	private CollaborationsTreePanel ctp;
	private ChangeMasterPanel cmp;
	private Panel panel;
	
	public CollaborationComponent(CometStandAloneBPMNEditor cometEditor){
		super("Collaboration");
		this.cometEditor = cometEditor;
		this.collab = cometEditor.getCollaboration();
	}
	
	@Override
	public Widget getComponent() {
		panel = new Panel();
//		panel.setLayout(new VerticalLayout());
		
		ctp = new CollaborationsTreePanel();
		List<Collaboration> l = new ArrayList<Collaboration>();
		l.add(collab);
		ctp.displayCollaborations(l);
		
		panel.add(ctp);
		
//		cmp = new ChangeMasterPanel(collab);
//		panel.add(cmp);
		
		Panel buttonPanel = new Panel("Lock options");
		
		Button lockButton = new Button("Lock");
		lockButton.addListener(new ButtonListenerAdapter(){
			@Override
			public void onClick(Button button, EventObject e){
				cometEditor.lock();
			}
		});
		buttonPanel.add(lockButton);
		
		Button unlockButton = new Button("Unlock");
		unlockButton.addListener(new ButtonListenerAdapter(){
			@Override
			public void onClick(Button button, EventObject e){
				cometEditor.unlock();
			}
		});
		buttonPanel.add(unlockButton);
		
		panel.add(buttonPanel);
		
		return panel;
//		return ctp;
	}

	public void refresh(){
		List<Collaboration> l = new ArrayList<Collaboration>();
		l.add(collab);
		ctp.displayCollaborations(l);
		
//		panel.remove(cmp);
//		cmp = new ChangeMasterPanel(collab);
//		panel.add(cmp);
	}
}
