/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui;

import java.util.Collection;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.UserGroup;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.AccordionLayout;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;

public class GroupPanel extends Panel{

	public GroupPanel(Collection<UserGroup> userGroups){

		super();

		setBorder(false);
		setBodyBorder(false);

		setTitle("GroupPanel");  

		AccordionLayout accl = new AccordionLayout(true);
		accl.setFill(false);

		setLayout(accl);
		
		for (UserGroup userGroup: userGroups){

			Panel userGroupPanel = new Panel();
			userGroupPanel.setTitle(userGroup.getName());


			TreePanel groupTree = new TreePanel();
			groupTree.setBorder(false);
			TreeNode root = new TreeNode();

			for(User user:userGroup.getUsers()){

				String label = user.getId();

				TreeNode elementNode = new TreeNode(label); 

				root.appendChild(elementNode);

			}

			groupTree.setEnableDrop(false);
			groupTree.setEnableDD(true);
			groupTree.setRootNode(root);
			groupTree.setRootVisible(false);
			groupTree.setLines(false);
			//groupTree.setDdGroup("diagramPanel");


			userGroupPanel.add(groupTree);
			
			add(userGroupPanel);
			
		}

		//setAutoWidth(true);
		setAutoHeight(true);
	}
}
