/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.editor;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.ChangeDrawingPanelEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.CloseDrawingPanelEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.InitializationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.LockEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.ModificationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.NewDrawingPanelEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.ServiceEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.UnlockEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.UserJoinedCollaborationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.UserLeftCollaborationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.service.DeltaService;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.service.DeltaServiceAsync;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry.CometLogEntry;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry.CometLogEntryExecutor;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui.CollaborationComponent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditor;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditorConfiguration;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditorConfiguration.FunctionnalityConfiguration;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditorConfiguration.ViewConfiguration;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.DefinitionsSyntaxModel;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.DiagramToDefinitionsLoader;
import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DesignerListenerAdapter;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.LogListenerAdapter;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.helper.UniqueIdGenerator;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.AbstractLogEntry;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.Window.ClosingEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.gwtext.client.widgets.MessageBox;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.RemoteEventService;
import de.novanic.eventservice.client.event.RemoteEventServiceFactory;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.client.event.listener.RemoteEventListener;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEvent;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEventListener;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEventListener.Scope;



public class CometStandAloneBPMNEditor extends AbstractCollaborativeStandAloneBPMNEditor {
	
	private Domain deltaDomain;
	private User user;
	private Collaboration collaboration;
	
	private String editorId;
	private final DeltaServiceAsync deltaService = GWT.create(DeltaService.class);
	private RemoteEventService remoteEventService;
	
	private List<CometLogEntry> receivedModifications;	
	private CometLogEntryExecutor executor;
	
	private CollaborationComponent collaborationComponent;
	
	
	
	public CometStandAloneBPMNEditor(User u, Collaboration c){
		super();
		
		receivedModifications = new ArrayList<CometLogEntry>();
		
		this.user = u;
		editorId = user.getId();
		
		deltaDomain = DomainFactory.getDomain(c.getDomainName());
		collaboration = c;
		collaboration.addParticipant(user);
		
		if(collaboration.isMaster(user)){
			isNewbie = false;
		}
		
		executor = new CometLogEntryExecutor(this);

		deltaService.joinCollaboration(user, collaboration.getName(), new AsyncCallback<Void>() {
			public void onSuccess(Void arg0) {}
			public void onFailure(Throwable arg0) {
				System.out.println(arg0);
				MessageBox.alert("I could not join the collaboration");
			}
		});
		
		
		
		remoteEventService = RemoteEventServiceFactory.getInstance().getRemoteEventService();
		remoteEventService.addListener(deltaDomain, new RemoteDeltaListener());
		
		
		
		remoteEventService.addUnlistenListener(Scope.LOCAL, new UnlistenEventListener() {
			public void apply(Event anEvent) {}
			
			public void onUnlisten(UnlistenEvent anUnlistenEvent) {
				remoteEventService.addListener(deltaDomain, new RemoteDeltaListener());
			}
		}, new AsyncCallback<Void>() {
			public void onFailure(Throwable arg0) {}
			public void onSuccess(Void arg0) {}
		});
		
		
		Window.addWindowClosingHandler(new Window.ClosingHandler() {
			public void onWindowClosing(ClosingEvent event) {
				event.setMessage("Are you sure you want to exit ?\nMake sure you saved your process(es) if you wanted to.");
			}
		});

		Window.addCloseHandler(new CloseHandler<Window>() {
			public void onClose(CloseEvent<Window> arg0) {
				//TODO remoteEventService.removeListener(collaboration.getDomainName(),);

				deltaService.leaveCollaboration(user, new AsyncCallback<Void>() {
					public void onFailure(Throwable arg0) {
						//TODO remove trace
						System.out.println(arg0);
						MessageBox.alert(arg0.getMessage());
					}
					public void onSuccess(Void arg0) {}
				});
			}
		});

	}
	
	
	
	public void onModuleLoad() {
		BPMNEditorConfiguration conf = new BPMNEditorConfiguration();

		//functionnality configuration
		FunctionnalityConfiguration fConf = conf.new FunctionnalityConfiguration();
		fConf.setCPAT(false);
		conf.setFunctionnalityConfiguration(fConf);

		//view configuration
		ViewConfiguration vConf = conf.new ViewConfiguration();
		vConf.setDisplaySouthPanel(true);

		conf.setViewConfiguration(vConf);

		this.bpmneditor = new BPMNEditor(conf);
		
		DeferredCommand.addCommand(new Command(){
			public void execute() {
				bpmneditor.getController().unmask();
			}
		});
		
		collaborationComponent = new CollaborationComponent(this);
		collaborationComponent.displayInPosition("westPanel");
		bpmneditor.registerComponent(collaborationComponent);
		collaborationComponent.displayOnView(new DiagramView("Collaboration"));
		
		addWaveMenu();

		if(!isNewbie){
			addDrawingPanelTabListener();
		}
		
		
		//bpmneditor.addDesignerListener(new WaveEditorListener(this));
		bpmneditor.addDesignerListener(new DesignerListenerAdapter() {
			public void onLoadDiagram(DiagramSyntax syntax, SyntaxModel model,
					final DrawingPanel drawingPanel) {
				
				String id = ((DefinitionsSyntaxModel)model).getId();
				if(getDefinitions(id)==null) {
					addDefinitions((DefinitionsSyntaxModel)model);
					initDefs(((DefinitionsSyntaxModel)model).getId());
					//let the other know you have opened a new tab
					pushDefs(id);
				}
				
				DeferredCommand.addCommand(new Command() {
					public void execute() {
						addLogListener(drawingPanel);
					}
				});
			}
		});
		
		RootPanel.get().add(bpmneditor);
		bpmneditor.getController().mask("Loading designer, please wait ...");
	}

	
	private void addLogListener(DrawingPanel drawingPanel){
		drawingPanel.getLog().addListener(new LogListenerAdapter() {
			public void onUndo(AbstractLogEntry undoneLogEntry) {
				// TODO handle undo of a log entry
				//send a to containing the defsID --> on the other end only call undo on the corresponding log
				//problem : intercept the entry created by the undo
			}
			public void onRedo(AbstractLogEntry redoneLogEntry) {
				// TODO handle redo of an entry
			}
			public void onEntryAdded(final AbstractLogEntry addedLogEntry) {
				DeferredCommand.addCommand(new Command() {
					public void execute() {
						
						//TODO remove trace
						System.out.println("new log entry  "+addedLogEntry);
						
						pushModif(addedLogEntry);
					}
				});
			}
		});
	}
	
	
	@Override
	public String getParticipant() {
		return editorId;
	}

	
	@Override
	public void pushCurrentDPId(String defsId) {
		deltaService.changeDrawingPanel(user,defsId, new AsyncCallback<Void>() {
			public void onFailure(Throwable arg0) {
				MessageBox.alert("Drawing panel shift failed. "+arg0.getMessage());
			}
			public void onSuccess(Void arg0) {}
		});
	}
	

	@Override
	public void pushClosingDPId(String defsId) {
		deltaService.closeDrawingPanel(user, defsId, new AsyncCallback<Void>() {
			public void onFailure(Throwable arg0) {
				MessageBox.alert("Drawing panel closing failed. "+arg0.getMessage());
			}
			public void onSuccess(Void arg0) {}
		});
	}

	@Override
	public void pushDefs(String id) {
		deltaService.newDrawingPanel(user,getDefinitions(id), new AsyncCallback<Void>() {
			public void onFailure(Throwable arg0) {
				MessageBox.alert("New drawing panel push failed. "+arg0.getMessage());
			}
			public void onSuccess(Void arg0) {}
		});
	}

	@Override
	public void pushModif(AbstractLogEntry entry) {
		CometLogEntry cle = CometLogEntry.adapt(entry); 
		
		if(cle!=null && !wasReceived(cle)){
			deltaService.submitModification(user,cle, new AsyncCallback<Void>() {
				public void onFailure(Throwable arg0) {
					MessageBox.alert("Modification push failed. "+arg0.getMessage());
				}
				public void onSuccess(Void arg0) {}
			});
		}
	}

	
	private boolean wasReceived(CometLogEntry cle) {
		CometLogEntry e = null;
		for(CometLogEntry entry : receivedModifications){
			if(entry.isSimilar(cle)){
				e = entry;
				break;
			}
		}
		
		if(e!=null){
			receivedModifications.remove(e);
			return true;
		}
		else{
			return false;
		}
	}



	@Override
	public void unlock() {
		deltaService.unlock(user, new AsyncCallback<Boolean>() {
			public void onFailure(Throwable arg0) {
				MessageBox.alert(arg0.getMessage());
			}

			public void onSuccess(Boolean arg0) {
				if(arg0){
					MessageBox.alert("J'ai débloqué tout le monde");
				}
				else{
					MessageBox.alert("J'ai pas la main");
				}
			}
		});
	}
	
	
	
	@Override
	public void lock() {
		deltaService.lock(user, new AsyncCallback<Boolean>() {
			public void onFailure(Throwable arg0) {
				MessageBox.alert(arg0.getMessage());
			}
			public void onSuccess(Boolean arg0) {
				if(arg0){
					MessageBox.alert("J'ai bloqué tout le monde");
				}
				else{
					MessageBox.alert("J'ai pas la main");
				}
			}
		});
	}
	
	
	
	@Override
	public String createUniqueId() {
		return UniqueIdGenerator.createUniqueId();
	}
	
	
	
	public Collaboration getCollaboration() {
		return collaboration;
	}

	


	private class RemoteDeltaListener implements RemoteEventListener {
		
		public void apply(Event event) {
			if(event instanceof ServiceEvent){
				ServiceEvent se = (ServiceEvent) event;
				
				if(!se.getEditorID().equals(editorId)){
					
					if(event instanceof ModificationEvent){
						ModificationEvent me = (ModificationEvent) event;
						CometLogEntry entry = me.getEntry();
						
						receivedModifications.add(entry);
						
						//TODO remove try catch
						try{
							executor.execute(entry);
							
							//TODO remove trace
							System.out.println("modification applied by "+editorId);
						}
						catch(Exception e){
							e.printStackTrace();
						}
					}
					
					
					else if(event instanceof NewDrawingPanelEvent){
						NewDrawingPanelEvent ndpe = (NewDrawingPanelEvent) event;

						CometStandAloneBPMNEditor.this.addDefinitions(ndpe.getDefsBean());
						
						CometStandAloneBPMNEditor.this.displayModel(ndpe.getDefsBean());
					}
					
					
					else if(event instanceof ChangeDrawingPanelEvent){
						ChangeDrawingPanelEvent cdpe = (ChangeDrawingPanelEvent) event;
						
						bpmneditor.getController().activateDrawingPanelById(cdpe.getModelId());
					}
					
					
					else if(event instanceof CloseDrawingPanelEvent){
						CloseDrawingPanelEvent cdpe = (CloseDrawingPanelEvent) event;
						
						DrawingPanel dp = bpmneditor.getController().getModel().getDrawingPanelBySyntaxModelId(cdpe.getModelId());
						if(dp!=null){
							definitions.remove(cdpe.getModelId());
							bpmneditor.getRegistry().getLayout().getDrawingPanelTab().removeDrawingPanel(dp);
						}
					}
					
					
					else if(event instanceof LockEvent){
						DrawingPanel dp = getBPMNEditor().getRegistry().getLayout().getDrawingPanelTab().getCurrentDrawingPanel();
						try{
							if(!dp.getEl().isMasked()){
								dp.getEl().mask();
								MessageBox.alert("Je suis bloqué !!");
							}
						}
						catch(Exception e){
							dp.getEl().mask();
							MessageBox.alert("Je suis bloqué !!");
						}
					}
					
					
					else if(event instanceof UnlockEvent){
						DrawingPanel dp = getBPMNEditor().getRegistry().getLayout().getDrawingPanelTab().getCurrentDrawingPanel();
						try{
							if(dp.getEl().isMasked()){
								dp.getEl().unmask();
								MessageBox.alert("Je suis débloqué !!");
							}
						}
						catch(Exception e){
							return;
						}
					}
					
					
					else if(event instanceof UserJoinedCollaborationEvent){
						UserJoinedCollaborationEvent uje = (UserJoinedCollaborationEvent) event;
						
						collaboration.addParticipant(uje.getUser());
						collaborationComponent.refresh();
						
						MessageBox.alert(uje.getEditorID()+" joined.\nThe master is "+uje.getCollaboration().getMaster().getId());
						
						if(collaboration.isMaster(user)){
							ArrayList<DefinitionsSyntaxModel> state = new ArrayList<DefinitionsSyntaxModel>();
							for(String defsId : definitions.keySet()){
								DrawingPanel dp = bpmneditor.getController().getModel().getDrawingPanelBySyntaxModelId(defsId);
								state.add(new DiagramToDefinitionsLoader(dp).getDefinitions());
							}
							
							deltaService.pushCurrentState(user, state, new AsyncCallback<Void>() {
								public void onFailure(Throwable arg0) {
									arg0.printStackTrace(System.out);
								}
								public void onSuccess(Void arg0) {}
							});
						}
					}
					
					
					else if(event instanceof InitializationEvent){
						if(isNewbie){
							final InitializationEvent ie = (InitializationEvent) event;
							
							DeferredCommand.addCommand(new IncrementalCommand() {
								private int i = 0;
								
								public boolean execute() {
									displayModel(ie.getState().get(i));
									i++;
									return i<ie.getState().size();
								}
							});
						}
						
						isNewbie = false;
						DeferredCommand.addCommand(new Command() {
							public void execute() {
								addDrawingPanelTabListener();
							}
						});
					}
					
					
					else if(event instanceof UserLeftCollaborationEvent){
						UserLeftCollaborationEvent ule = (UserLeftCollaborationEvent) event;
						
						collaboration.removeParticipant(ule.getUser());
						
						collaborationComponent.refresh();
						
						MessageBox.alert(ule.getEditorID()+" left.\nThe master is "+ule.getCollaboration().getMaster().getId());
					}
				}
			}
		}
	}

}
