/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.UserGroup;

public class CollaborationStatus implements Serializable{

	private List<UserGroup> users;
	private List<Collaboration> collaborations;
	
	public CollaborationStatus(){
		this.users = new ArrayList<UserGroup>();
		this.collaborations = new ArrayList<Collaboration>();
	}
	
	public CollaborationStatus(List<UserGroup> users,
			List<Collaboration> collaborations) {
		this.users = users;
		this.collaborations = collaborations;
	}

	public List<UserGroup> getUsers() {
		return users;
	}

	public void setUsers(List<UserGroup> users) {
		this.users = users;
	}

	public List<Collaboration> getCollaborations() {
		return collaborations;
	}

	public void setCollaborations(List<Collaboration> collaborations) {
		this.collaborations = collaborations;
	}
	
	public User getUserById(String userId){
		for(UserGroup ug : users){
			for(User u : ug.getUsers()){
				if(u.getId().equals(userId)){
					return u;
				}
			}
		}
		return null;
	}
	
	public UserGroup getUsersById(Collection<String> usersId){
		UserGroup result = new UserGroup();
		for(String s : usersId){
			result.addUser(getUserById(s));
		}
		return result;
	}
	
	public Collaboration getCollaborationByName(String name){
		for(Collaboration c : collaborations){
			if(c.getName().equals(name)){
				return c;
			}
		}
		return null;
	}
	
}
