/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.PoolElement;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.editor.CometStandAloneBPMNEditor;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.helper.DefinitionsLoaderHelper;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.helper.ModelLoaderHelper;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.component.BPMNDrawingPanel;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.DiagramConnector;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;

public class CometLogEntryExecutor {
	
	private CometStandAloneBPMNEditor editor;
	

	public CometLogEntryExecutor(CometStandAloneBPMNEditor editor) {
		this.editor = editor;
	}

	
	public void execute(CometLogEntry entry){
		DrawingPanel dp = editor.getBPMNEditor().getController().getModel().getDrawingPanelBySyntaxModelId(entry.getModelId());
		
		if(entry instanceof AddElementCometLogEntry){
			AddElementCometLogEntry addEntry = (AddElementCometLogEntry) entry;
			executeAddEntry(dp, addEntry);
		}
		else if(entry instanceof RemoveElementCometLogEntry){
			DiagramElementInstance ei = dp.getElementInstanceById(entry.getDiagramElementId());
			dp.removeElement(ei);
		}
		else if(entry instanceof UpdateElementCometLogEntry){
			UpdateElementCometLogEntry moveEntry = (UpdateElementCometLogEntry) entry;
			executeUpdateElementEntry(dp,moveEntry);
		}
		else if(entry instanceof UpdateConnectorCometLogEntry){
			UpdateConnectorCometLogEntry updateEntry = (UpdateConnectorCometLogEntry) entry;
			executeUpdateConnectorEntry(dp,updateEntry);
		}
		else if(entry instanceof PropertyChangedCometLogEntry){
			PropertyChangedCometLogEntry pce = (PropertyChangedCometLogEntry) entry;
			executePropertyChangedEntry(dp,pce);
		}
	}
	
	
	
	


	private void executeAddEntry(DrawingPanel dp, AddElementCometLogEntry addEntry){

		new DefinitionsLoaderHelper((BPMNDrawingPanel)dp).load(addEntry.getBean(),addEntry.getParentId());
			
	}
	
	
	
	
	
	private void executeUpdateElementEntry(DrawingPanel dp, UpdateElementCometLogEntry updateEntry) {
		DiagramElementInstance dei = dp.getElementInstanceById(updateEntry.getDiagramElementId());
		DiagramElement de = (DiagramElement) dei.getViewInstance();
		if(updateEntry.getParentId()!=null){
			DiagramElementInstance parent = dp.getElementInstanceById(updateEntry.getParentId());
			DiagramElement p = (DiagramElement) parent.getViewInstance();
			
			setParent(de,p);
			
		}
		de.setX(updateEntry.getNewX());
		de.setY(updateEntry.getNewY());
		
		de.refresh();
	}
	
	private void setParent(DiagramElement child, DiagramElement parent) {
		if(child instanceof LaneElement){
			LaneElement le = (LaneElement) child;
			if(!le.getParentPool().getId().equals(parent.getId())){
				PoolElement newParentPool = (PoolElement)parent;
				
				le.getParentPool().removeLane(le);
				le.setParentPool((PoolElement)parent);
				newParentPool.addLane(le);
			}
		}
		else if(child instanceof FlowNodeElement){
			//TODO
		}
	}

	
	

	private void executeUpdateConnectorEntry(DrawingPanel dp, UpdateConnectorCometLogEntry updateEntry) {
		DiagramElementInstance connectorInstance = dp.getElementInstanceById(updateEntry.getDiagramElementId());
		DiagramConnector connector = (DiagramConnector) connectorInstance.getViewInstance();
		
		DiagramElementInstance sourceInstance = dp.getElementInstanceById(updateEntry.getSourceId());
		DiagramElementInstance targetInstance = dp.getElementInstanceById(updateEntry.getTargetId());
		
		FlowNodeElement source = (FlowNodeElement) sourceInstance.getViewInstance();
		FlowNodeElement target = (FlowNodeElement) targetInstance.getViewInstance();
		
		connector.connect(source.getConnectable(),target.getConnectable());
	}

	
	
	
	private void executePropertyChangedEntry(DrawingPanel dp,
			PropertyChangedCometLogEntry pce) {
		
		DiagramElementInstance ei = dp.getElementInstanceById(pce.getDiagramElementId());
		ModelLoaderHelper.loadModel(pce.getBean(), ei);
	}
	
}
