/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;


public class RemoveElementCometLogEntry extends CometLogEntry{

	private int x;
	private int y;
	
	public RemoveElementCometLogEntry(){
		super();
	}
	
	public RemoveElementCometLogEntry(String eiId, String modelId, int x, int y){
		super(eiId,modelId);
		this.x = x;
		this.y = y;
	}
	
	
	@Override
	public boolean isSimilar(CometLogEntry other) {
		if(other instanceof RemoveElementCometLogEntry){
			RemoveElementCometLogEntry e = (RemoveElementCometLogEntry) other;
			return checkIds(other) && e.getX()==x && e.getY()==y;
		}
		return false;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

}
