/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;

public class UpdateConnectorCometLogEntry extends CometLogEntry {

	private String sourceId;
	private String targetId;
	

	public UpdateConnectorCometLogEntry(){}

	
	
	public UpdateConnectorCometLogEntry(String eiId, String dpId, String sourceId, String targetId) {
		super(eiId,dpId);
		this.sourceId = sourceId;
		this.targetId = targetId;
	}



	@Override
	public boolean isSimilar(CometLogEntry other) {
		if(other instanceof UpdateConnectorCometLogEntry){
			UpdateConnectorCometLogEntry e = (UpdateConnectorCometLogEntry) other;
			return checkIds(other) && sourceId.equals(e.sourceId) && targetId.equals(e.targetId);
		}
		return false;
	}

	
	
	public String getSourceId() {
		return sourceId;
	}



	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}



	public String getTargetId() {
		return targetId;
	}



	public void setTargetId(String targetId) {
		this.targetId = targetId;
	}
}
