/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;

public class CollaborationsTreePanel extends TreePanel{
	

	public CollaborationsTreePanel(){
		super();
		setTitle("CollabortionPanel"); 
		
		TreeNode root = new TreeNode("Collaborations");
		root.setExpanded(true); 
		setRootNode(root);
	}
	
	public void displayCollaborations(Collection<Collaboration> collaborations){
		TreeNode root = getRootNode();
		for(Node child : root.getChildNodes()){
			root.removeChild(child);
		}
		
		for(Collaboration collab : collaborations){
			
			TreeNode groupNode = new TreeNode(collab.getName());
			groupNode.setExpanded(true);
			groupNode.setChecked(false);
			
			for(User user : collab.getInvitedParticipants().getUsers()){
				String text = user.getId();
				
				if(collab.isMaster(user)){
					text += " M";
				}
				if(collab.getPresentParticipants().isInGroup(user)){
					text += " (present)";
				}
				
				TreeNode userNode = new TreeNode(text);
				groupNode.appendChild(userNode);
			}
			
			root.appendChild(groupNode);
		}
		
		root.expand();
	}
	
	
	public List<String> getSelectedCollaborations(){
		List<String> result = new ArrayList<String>();
		for(TreeNode node : getChecked()){
			result.add(node.getText());
		}
		return result;
	}
}
