/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user;

import java.io.Serializable;

public class Collaboration implements Serializable{

	private String name;
	private String domainName;
	private UserGroup invitedParticipants;
	private UserGroup presentParticipants;
	private User master;
	
	public Collaboration(){}
	
	public Collaboration(String name, String domainName, UserGroup invitedParticipants) {
		super();
		this.name = name;
		this.domainName = domainName;
		this.invitedParticipants = invitedParticipants;
		this.presentParticipants = new UserGroup();
	}
	
	
	public void addParticipant(User user){
		if(presentParticipants.getUsers().isEmpty()){
			master = user;
		}
		presentParticipants.addUser(user);
	}
	
	public User removeParticipant(User user){
		if(master.equals(user)){
			master = null;
		}
		presentParticipants.removeUser(user);
		if(master == null && !presentParticipants.getUsers().isEmpty()){
			master = presentParticipants.getUsers().iterator().next(); 
		}
		return master;
	}
	
	public boolean isMaster(User u){
		if(master!=null){
			return u.getId().equals(master.getId());
		}
		return false;
	}
	
	public User getUser(String userId){
		for(User user : invitedParticipants.getUsers()){
			if(user.getId().equals(userId)){
				return user;
			}
		}
		return null;
	}

	public String getName() {
		return name;
	}

	public String getDomainName() {
		return domainName;
	}

	public UserGroup getInvitedParticipants() {
		return invitedParticipants;
	}

	public UserGroup getPresentParticipants() {
		return presentParticipants;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public void setInvitedParticipants(UserGroup invitedParticipants) {
		this.invitedParticipants = invitedParticipants;
	}

	public void setPresentParticipants(UserGroup presentParticipants) {
		this.presentParticipants = presentParticipants;
	}
	
	public boolean isInvited(User u){
		return invitedParticipants.isInGroup(u);
	}
	
	@Override
	public boolean equals(Object other){
		Collaboration c = (Collaboration) other;
		return c.name.equals(name) && c.domainName.equals(domainName);
	}

	public User getMaster() {
		return master;
	}

	public void setMaster(User master) {
		this.master = master;
	}
	
	
}
