/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.mock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.BasicUser;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.UserGroup;

public class MockUserDB {
	
	private List<UserGroup> groups;
	private Set<User> connected;
	
	public MockUserDB(){
		groups = new ArrayList<UserGroup>();
		connected = new HashSet<User>();
		
		UserGroup ug1 = new UserGroup("Group 1");
		ug1.addUser(new BasicUser("Michel"));
		ug1.addUser(new BasicUser("Robert"));
		ug1.addUser(new BasicUser("Christian"));
		
		UserGroup ug2 = new UserGroup("Group 2 ");
		ug2.addUser(new BasicUser("Ginette"));
		ug2.addUser(new BasicUser("Geraldine"));
		
		UserGroup ug3 = new UserGroup("Group 3 ");
		ug3.addUser(new BasicUser("Louis"));
		ug3.addUser(new BasicUser("Bernard"));
		ug3.addUser(new BasicUser("Mateja"));
		
		UserGroup ug4 = new UserGroup("EBM - Research");
		ug4.addUser(new BasicUser("Nicholas"));
		ug4.addUser(new BasicUser("Nicolas"));
		ug4.addUser(new BasicUser("Jean Pierre"));
		ug4.addUser(new BasicUser("Thierry"));
		ug4.addUser(new BasicUser("Graham"));
		ug4.addUser(new BasicUser("Julien"));
		ug4.addUser(new BasicUser("Sarah"));
		
		groups.add(ug1);
		groups.add(ug2);
		groups.add(ug3);
		groups.add(ug4);
	}

	public boolean connect(String userId){
		for(UserGroup ug : groups){
			for(User u : ug.getUsers()){
				if(u.getId().equals(userId) && !connected.contains(u)){
					connected.add(u);
					return true;
				}
			}
		}
		return false;
	}
	
	public boolean disconnect(String userId){
		for(User u : connected){
			if(u.getId().equals(userId)){
				connected.remove(u);
				return true;
			}
		}
		return false;
	}
	
	public List<UserGroup> getUsers(){
		return groups;
	}
}
