/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.IPoint;

/**
 * Edge specifies a given edge in a graph of diagram elements.
 * It represents a polyline connection between two graph elements: a
 * source and a target.
 * 
 * @author nfleury
 *
 */
public interface IEdge extends IDiagramElement{

	LinkedHashSet<IPoint> getWayPoints();
	
	IDiagramElement getSource();
	
	IDiagramElement getTarget();
	
	void setSource(IDiagramElement source);
	
	void setTarget(IDiagramElement target);
	
	void addWayPoint(IPoint point);
	
	void removeWayPoint(IPoint point);
	
	void clearWayPoints();
}
