/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.geasygraph.impl.alphastar;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasygraph.api.INode;
import com.ebmwebsourcing.geasytools.geasygraph.impl.Graph;
import com.ebmwebsourcing.geasytools.geasygraph.impl.Node;
import com.ebmwebsourcing.geasytools.geasygraph.impl.alphastar.AlphaNode;
import com.ebmwebsourcing.geasytools.geasygraph.impl.alphastar.AlphaStarPathFinder;
import java.util.LinkedHashSet;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlphaStarPathFinderTest {
    private Graph graph;

    @Before
    public void init() {
        int graphSize = 3;
        this.graph = new Graph();
        for (int x = 0; x < graphSize; ++x) {
            for (int y = 0; y < graphSize; ++y) {
                AlphaNode alphaNode = new AlphaNode(x + "," + y, (float)x, (float)y);
                this.graph.addNode((INode)alphaNode);
            }
        }
        for (Node node : this.graph.getNodes()) {
            String topleft = "" + ((int)node.getX() - 1) + "," + ((int)node.getY() - 1);
            String top = "" + (int)node.getX() + "," + ((int)node.getY() - 1);
            String topRight = "" + ((int)node.getX() + 1) + "," + ((int)node.getY() - 1);
            String left = "" + ((int)node.getX() - 1) + "," + (int)node.getY();
            String bottomLeft = "" + ((int)node.getX() - 1) + "," + ((int)node.getY() + 1);
            String bottom = "" + (int)node.getX() + "," + ((int)node.getY() + 1);
            String bottomRight = "" + ((int)node.getX() + 1) + "," + ((int)node.getY() + 1);
            String right = "" + ((int)node.getX() + 1) + "," + (int)node.getY();
            Node n1 = this.graph.getNodeById(topleft);
            Node n2 = this.graph.getNodeById(top);
            Node n3 = this.graph.getNodeById(topRight);
            Node n4 = this.graph.getNodeById(left);
            Node n5 = this.graph.getNodeById(bottomLeft);
            Node n6 = this.graph.getNodeById(bottom);
            Node n7 = this.graph.getNodeById(bottomRight);
            Node n8 = this.graph.getNodeById(right);
            if (n1 != null) {
                node.addAdjacentNode((INode)n1);
            }
            if (n2 != null) {
                node.addAdjacentNode((INode)n2);
            }
            if (n3 != null) {
                node.addAdjacentNode((INode)n3);
            }
            if (n4 != null) {
                node.addAdjacentNode((INode)n4);
            }
            if (n5 != null) {
                node.addAdjacentNode((INode)n5);
            }
            if (n6 != null) {
                node.addAdjacentNode((INode)n6);
            }
            if (n7 != null) {
                node.addAdjacentNode((INode)n7);
            }
            if (n8 == null) continue;
            node.addAdjacentNode((INode)n8);
        }
    }

    @Test
    public void findShortestPathSimpleWithAllNodeWalkable() {
        Node source = this.graph.getNodeById("0,0");
        Node target = this.graph.getNodeById("2,2");
        AlphaStarPathFinder alpha = new AlphaStarPathFinder((IGraph)this.graph, (INode)source, (INode)target);
        LinkedHashSet<INode> shortestPath = new LinkedHashSet<INode>();
        shortestPath.add((INode)this.graph.getNodeById("0,0"));
        shortestPath.add((INode)this.graph.getNodeById("1,1"));
        shortestPath.add((INode)this.graph.getNodeById("2,2"));
        LinkedHashSet path = alpha.getShortestPath();
        System.out.println("Shortest path with all nodes walkable:" + path);
        Assert.assertTrue((boolean)this.pathsAreSimilar(shortestPath, path));
    }

    @Test
    public void findShortestPathSimpleWithNonWalkable1() {
        Node source = this.graph.getNodeById("0,0");
        Node target = this.graph.getNodeById("2,2");
        Node unwalkableNode1 = this.graph.getNodeById("1,1");
        Node unwalkableNode2 = this.graph.getNodeById("0,1");
        AlphaStarPathFinder alpha = new AlphaStarPathFinder((IGraph)this.graph, (INode)source, (INode)target);
        alpha.addNonWalkableNode((INode)unwalkableNode1);
        alpha.addNonWalkableNode((INode)unwalkableNode2);
        LinkedHashSet<INode> shortestPath = new LinkedHashSet<INode>();
        shortestPath.add((INode)this.graph.getNodeById("0,0"));
        shortestPath.add((INode)this.graph.getNodeById("1,0"));
        shortestPath.add((INode)this.graph.getNodeById("2,1"));
        shortestPath.add((INode)this.graph.getNodeById("2,2"));
        LinkedHashSet path = alpha.getShortestPath();
        System.out.println("Shortest path with non walkable nodes 1,1 - 0,1 :" + path);
        Assert.assertTrue((boolean)this.pathsAreSimilar(shortestPath, path));
    }

    @Test
    public void findShortestPathSimpleWithNonWalkable2() {
        Node source = this.graph.getNodeById("0,0");
        Node target = this.graph.getNodeById("2,2");
        Node unwalkableNode1 = this.graph.getNodeById("1,1");
        Node unwalkableNode2 = this.graph.getNodeById("1,0");
        AlphaStarPathFinder alpha = new AlphaStarPathFinder((IGraph)this.graph, (INode)source, (INode)target);
        alpha.addNonWalkableNode((INode)unwalkableNode1);
        alpha.addNonWalkableNode((INode)unwalkableNode2);
        LinkedHashSet<INode> shortestPath = new LinkedHashSet<INode>();
        shortestPath.add((INode)this.graph.getNodeById("0,0"));
        shortestPath.add((INode)this.graph.getNodeById("0,1"));
        shortestPath.add((INode)this.graph.getNodeById("1,2"));
        shortestPath.add((INode)this.graph.getNodeById("2,2"));
        LinkedHashSet path = alpha.getShortestPath();
        System.out.println("Shortest path with non walkable nodes 1,1 - 1,0 :" + path);
        Assert.assertTrue((boolean)this.pathsAreSimilar(shortestPath, path));
    }

    @Test
    public void findShortestPathSimpleWithNonWalkable3() {
        Node source = this.graph.getNodeById("0,0");
        Node target = this.graph.getNodeById("2,2");
        Node unwalkableNode1 = this.graph.getNodeById("1,1");
        Node unwalkableNode2 = this.graph.getNodeById("2,1");
        Node unwalkableNode3 = this.graph.getNodeById("1,0");
        AlphaStarPathFinder alpha = new AlphaStarPathFinder((IGraph)this.graph, (INode)source, (INode)target);
        alpha.addNonWalkableNode((INode)unwalkableNode1);
        alpha.addNonWalkableNode((INode)unwalkableNode2);
        alpha.addNonWalkableNode((INode)unwalkableNode3);
        LinkedHashSet<INode> shortestPath = new LinkedHashSet<INode>();
        shortestPath.add((INode)this.graph.getNodeById("0,0"));
        shortestPath.add((INode)this.graph.getNodeById("0,1"));
        shortestPath.add((INode)this.graph.getNodeById("1,2"));
        shortestPath.add((INode)this.graph.getNodeById("2,2"));
        LinkedHashSet path = alpha.getShortestPath();
        System.out.println("Shortest path with non walkable nodes 1,1 - 2,1 - 1,0 :" + path);
        Assert.assertTrue((boolean)this.pathsAreSimilar(shortestPath, path));
    }

    public boolean pathsAreSimilar(LinkedHashSet<INode> path1, LinkedHashSet<INode> path2) {
        Object[] nodes1 = path1.toArray();
        Object[] nodes2 = path2.toArray();
        for (int i = 0; i <= nodes1.length - 1; ++i) {
            if (nodes1[i].equals(nodes2[i])) continue;
            return false;
        }
        return true;
    }
}

