/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;


import com.ebmwebsourcing.geasytools.geasysvg.core.api.IContainer;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGDocument;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.google.gwt.core.client.JavaScriptObject;

/**
 * Getters should only return data stored by respective implementation
 * 
 * @author nfleury
 *
 */
public class SVGElementJSNI implements ISVGElement{
	
	
	private JavaScriptObject svgElementJsObject;
	
	public SVGElementJSNI() {
	
	}

	
	protected JavaScriptObject getSvgElementJsObject() {
		return svgElementJsObject;
	}
	
	protected void setSvgElementJsObject(JavaScriptObject svgElementJsObject) {
		this.svgElementJsObject = svgElementJsObject;
	}
	
	@Override
	public ISVGDocument getCanvas() {return null;}

	@Override
	public String getFillColour() {return null;}

	@Override
	public float getFillOpacity() {return 0;}

	@Override
	public float getHeight() {return (float) getHeightJS(svgElementJsObject);}

	@Override
	public String getId() {return null;}

	@Override
	public String getStrokeColour() {return null;}

	@Override
	public String getStrokeDashArray() {return null;}

	@Override
	public float getWidth() {return (float) getWidthJS(svgElementJsObject);}

	@Override
	public float getX() {return 0;}

	@Override
	public float getY() {return 0;}
	
	@Override
	public IContainer getContainer() {return null;}

	@Override
	public boolean isVisible() {return false;}

	@Override
	public void remove() {
		
		this.removeJS(getSvgElementJsObject());
		
	}

	@Override
	public void rotate(float degree, boolean isAbsolute) {
		
		this.rotateJS(getSvgElementJsObject(),degree, isAbsolute);
		
	}

	@Override
	public void rotate(float degree, int cx, int cy) {
		
		this.rotateJS(getSvgElementJsObject(), degree, cx, cy);
		
	}

	@Override
	public void scale(float xTimes, float yTimes) {
		
		this.scaleJS(getSvgElementJsObject(),xTimes,yTimes);
		
	}




	@Override
	public void scale(float xTimes, float yTimes, float centerX, float centerY) {
		
		this.scaleJS(getSvgElementJsObject(),xTimes,yTimes,centerX,centerY);
		
	}


	@Override
	public void setCanvas(ISVGDocument canvas) {}

	@Override
	public void setFillColour(String colour) {
			
		setFillColorJS(getSvgElementJsObject(), colour);
		
	}

	@Override
	public void setFillOpacity(float fillOpacity) {
		
		setFillOpacityJS(getSvgElementJsObject(),fillOpacity);
		
	}

	@Override
	public void setId(String id) {}

	@Override
	public void setStokeColour(String colour) {
		
		this.setStrokeColorJS(getSvgElementJsObject(), colour);
		
	}

	@Override
	public void setStrokeDashArray(String strokeDash) {
		
		this.setStrokeDashArrayJS(getSvgElementJsObject(), strokeDash);
		
	}

	@Override
	public void setVisible(boolean visible) {
		this.setVisibleJS(this.getSvgElementJsObject(),visible);
	}

	@Override
	public void setX(float x) {
		
		throw new IllegalStateException("Set x not implemented in "+this.getClass());
		
	}

	@Override
	public void setY(float y) {
		
		throw new IllegalStateException("Set y not implemented in "+this.getClass());
	}

	@Override
	public void toBack() {
		
		this.toBackJS(getSvgElementJsObject());
		
	}

	@Override
	public void toFront() {
		
		this.toFrontJS(getSvgElementJsObject());
		
	}

	@Override
	public void translate(float dx, float dy) {
		
		this.translateJS(getSvgElementJsObject(), dx, dy);
		
	}
	
	

	@Override
	public void setHeight(float height) {
		
		this.setHeightJS(getSvgElementJsObject(),height);
		
	}


	@Override
	public void setWidth(float width) {
		
		this.setWidthJS(getSvgElementJsObject(),width);
		
	}



	@Override
	public void setContainer(IContainer container) {
		// TODO Auto-generated method stub
		
	}
	
	/**
	 * JSNI IMPLEMENTATION OF SETTERS ONLY
	 ***************************************/
	
	
	private native void setVisibleJS(JavaScriptObject svgElement,boolean visible)/*-{
		
		
		if (visible==true){
		
			svgElement.show();
			
		}else{
			
			svgElement.hide();
			
		}		
		
		
	}-*/;
	
	
	private native void setFillColorJS(JavaScriptObject svgElement,String fillColour)/*-{
	
		svgElement.attr("fill",fillColour);
		
	}-*/;
	
	private native void setFillOpacityJS(JavaScriptObject svgElement,float fillOpacity)/*-{
	
		svgElement.attr("fill-opacity",fillOpacity);
	
	}-*/;
	
	private native void setStrokeColorJS(JavaScriptObject svgElement,String strokeColour)/*-{
	
		svgElement.attr("stroke",strokeColour);
	
	}-*/;
	
	private native void setStrokeDashArrayJS(JavaScriptObject svgElement,String dashArray)/*-{
	
		svgElement.attr("stroke-dasharray",dashArray);
	
	}-*/;
	
	private native void toBackJS(JavaScriptObject svgElement)/*-{
	
		svgElement.toBack();
		
	}-*/;

	private native void toFrontJS(JavaScriptObject svgElement)/*-{
		
		svgElement.toFront();
		
	}-*/;
	
	
	private native void translateJS(JavaScriptObject svgElement,float tx,float ty)/*-{
		
		svgElement.translate(tx,ty);
		
	}-*/;
	
	private native void removeJS(JavaScriptObject svgElement)/*-{
		
		svgElement.remove();
	
	}-*/;
	
	private native void rotateJS(JavaScriptObject svgElement,float degree, boolean isAbsolute)/*-{
		
		svgElement.rotate(degree);
	
	}-*/;
	
	private native void rotateJS(JavaScriptObject svgElement,float degree, int cx, int cy)/*-{
		
		svgElement.rotate(degree,cx,xy);
	
	}-*/;	
	
	private native void scaleJS(JavaScriptObject svgElement, float xTimes,float yTimes)/*-{
		
		svgElement.scale(xTimes,yTimes);
		
	}-*/;
	

	private native void scaleJS(JavaScriptObject svgElement, float xTimes,float yTimes, float centerX, float centerY)/*-{
		
		svgElement.scale(xTimes,yTimes,centerX,centerY);
	
	}-*/;

	
	private native void setWidthJS(JavaScriptObject svgElement,float width)/*-{

		svgElement.attr("width",width);
	
	}-*/;

	private native void setHeightJS(JavaScriptObject svgElement,float height)/*-{

		svgElement.attr("height",height);
	}-*/;

	private native double getWidthJS(JavaScriptObject svgElement)/*-{

		return svgElement.getBBox().width;
	
	}-*/;

	
	private native double getHeightJS(JavaScriptObject svgElement)/*-{

		return svgElement.getBBox().height;
	
	}-*/;
	
}
