/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.connectable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectableHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPositionable;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;

public interface IConnectableElement extends IDroppableElement,IPositionable{

	HashSet<IConnector> getIncommingConnectors();
	
	HashSet<IConnector> getOutgoingConnectors();
	
	void addConnectableHandler(IConnectableHandler connectableHandler);
	
	void addIncommingConnector(IConnector connector);
	
	void addOutgoingConnector(IConnector connector);
	
	void refreshMagnets();
	
	HashSet<IMagnet> getMagnets();
	
	float getWidth();
	
	float getHeight();
	
	IGraph getGraph();
	
	IConnectableElementDefaulHandlers getDefaultHandlers();
	
}
