/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu;


import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IDragProxyContextualMenuConfiguration;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragProxyHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedBeforeDropEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Widget;

public class DragProxyContextualMenu extends ContextualMenu implements IDragProxyContextualMenu{
	

	
	public DragProxyContextualMenu(IHasDragProxyContextualMenu hasContextualMenu) {
		super(hasContextualMenu);
	}
	
	public DragProxyContextualMenu(IHasDragProxyContextualMenu hasContextualMenu,IContextualMenu parentMenu) {
		super(hasContextualMenu, parentMenu);
	}
	
	
	public DragProxyContextualMenu(IHasDragProxyContextualMenu hasContextualMenu,IDragProxyContextualMenuConfiguration config) {
		super(hasContextualMenu,config);
	}
	
	@Override
	protected void init() {
		super.init();

		//add every drag proxy to current menu
		if (getHasContextualDragProxyMenu().getDragProxies()!=null){
			
			LinkedHashSet<IHasMenuDragProxy> ps = getHasContextualDragProxyMenu().getDragProxies();
			
			for(IHasMenuDragProxy p:ps){
				
				//if we are in a sub menu => set the right HasContextualMenu
				p.setContextualMenuSubject(getTopLevelHasContextualMenu());

				addDragProxyHandler(p);
				
				//check if actual dragProxy has some submenus
				//if yes create a new ContextualMenu
				if (p.getDragProxies()!=null && p.getDragProxies().size()>0){
					
					new DragProxyContextualMenu(p,this);
					
				}
				
				if (p instanceof Widget){
					
					mainPanel.add((Widget)p);
					
				}
				
			}
		}
	}
	
	private IHasDragProxyContextualMenu getTopLevelHasContextualMenu(){
		
		if (this.getParentMenu()==null){
		
			return this.getHasContextualDragProxyMenu();
		
		}else{
			
			IDragProxyContextualMenu current = (IDragProxyContextualMenu) this.getParentMenu();
			
			while(current.getParentMenu()!=null){
				
				
				current = (IDragProxyContextualMenu) current.getParentMenu();
				
			}
			
			return current.getHasContextualDragProxyMenu();
		}
		

	}
	
	
	private void addDragProxyHandler(IHasMenuDragProxy p){
		//add drag proxy handler
		p.addDragProxyHandler(new IDragProxyHandler() {
			
			@Override
			public void onProxyRefusedBeforeDrop(IProxyRefusedBeforeDropEvent event) {
			
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyRefusedAfterDrop(IProxyRefusedAfterDropEvent event) {
				
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyDragStop(IProxyDragStopEvent event) {
			
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyDragStart(IProxyDragStartEvent event) {
				
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyDragMove(IProxyDragMoveEvent event) {
				
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyAcceptedBeforeDrop(IProxyAcceptedBeforeDropEvent event) {
				
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onProxyAcceptedAfterDrop(IProxyAcceptedAfterDropEvent event) {
					
				getHasContextualDragProxyMenu().fireEvent((GwtEvent<?>) event);
				
			}
		});
	}
	
	
	public IDragProxyContextualMenuConfiguration getConfiguration() {
		return (IDragProxyContextualMenuConfiguration) super.getConfiguration();
	}
	
	
	public IHasDragProxyContextualMenu getHasContextualDragProxyMenu() {
		return (IHasDragProxyContextualMenu) super.getHasContextualDragProxyMenu();
	}
	
}
