/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;


import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorStart;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;

public class DefaultContainerConnectorHandler implements DropHandler,DragHandler{
	
	private IContainer container;
	private IUIPanel uiPanel;
	private IDraggableElement draggableContainer;
	
	private float lastDiffX;
	private float lastDiffY;
	
	public DefaultContainerConnectorHandler(IContainer container,IUIPanel uipanel) {

		this.container 	= container;
		this.uiPanel 	= uipanel;
		
		if (container instanceof IDraggableElement) {
			this.draggableContainer = (IDraggableElement) container;
		}
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		
	}

	@Override
	public void onOut(IOutEvent event) {
		
	}

	@Override
	public void onOver(IOverEvent event) {
	
	}

	@Override
	public void onMove(IDragMoveEvent event) {}

	@Override
	public void onStart(IDragStartEvent event) {
		
		//when start dragging hide every connectors
		for(IUIElement el:uiPanel.getUIElements().values()){
			
			if (el instanceof IConnector){
				
				IConnector connector = (IConnector) el;
				connector.hide();
			}
			
		}
	}

	@Override
	public void onStop(IDragStopEvent event) {
		
		//once we've finished to drag

		
		//=> show every connectors
		//=> and update every connector points
		
		for(IUIElement el:uiPanel.getUIElements().values()){
			
			if (el instanceof IConnector){
				
				IConnector connector = (IConnector) el;
				connector.show();
			}
			
		}
		
		this.lastDiffX = this.draggableContainer.getRelativeX() - event.getDragStartX();
		this.lastDiffY = this.draggableContainer.getRelativeY() - event.getDragStartY();
		
		//update every magnets of connectables
		updateConnectorPoints(container);
		

		
		//=> update every connectables magnets
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			
			@Override
			public void execute() {

				updateMagnets(container);	

			}
		});
		
	
	}
	
	private void updateMagnets(IContainer container){
		
		for(IUIElement el:container.getChildrenUIElements().values()){
			
			if(el instanceof IConnectableElement){
				
				IConnectableElement cel = (IConnectableElement) el;
				cel.refreshMagnets();

			}

			if (el instanceof IContainer){
				updateMagnets((IContainer) el);
			}
		}
		
	}
	
	private void updateConnectorPoints(IContainer actualContainer){
		
		
		//System.out.println("diffX:"+lastDiffX+"diffY:"+lastDiffY);
		if (actualContainer.getChildrenUIElements()!=null){
			for(IUIElement el:actualContainer.getChildrenUIElements().values()){
				
				//System.out.println("Checking:"+el.getId());
				
				if (el instanceof IConnectable){
					
					IConnectable connectable = (IConnectable) el;
					
					//System.out.println("el:"+el.getId()+" is a connectable with incomming connectors:"+connectable.getIncommingConnectors().size());
					
					for(IConnector c : connectable.getIncommingConnectors()){
						//System.out.println("incooming connector:"+c.getId());
						for(IConnectorPoint cp:c.getAllConnectorPoints()){
							//System.out.println("cp:"+cp.getId());
							if ((cp instanceof IConnectorEnd ==false) && (cp instanceof IConnectorStart==false)){
								//System.out.println("Moved cp:"+cp.getId());
								cp.setRelativeX(cp.getRelativeX()+lastDiffX+uiPanel.getScrollLeft());
								cp.setRelativeY(cp.getRelativeY()+lastDiffY+uiPanel.getScrollTop());
								
							}
							
						}
						
					}
					
				}
				
				if (el instanceof IContainer){
					updateConnectorPoints((IContainer) el);
				}
				
			}
		}
	}

	@Override
	public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}
	
}
