/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragProxyHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.google.gwt.event.shared.GwtEvent;

public class ProxyRefusedBeforeDropEvent extends GwtEvent<IDragProxyHandler> implements IProxyRefusedBeforeDropEvent{
	
	public static Type<IDragProxyHandler> TYPE = new Type<IDragProxyHandler>();
	
	private IDragProxy dragProxy;
	private IRefusedBeforeDropEvent refusedBeforeDropEvent;
	
	public ProxyRefusedBeforeDropEvent(IDragProxy dragProxy,IRefusedBeforeDropEvent refusedBeforeDropEvent) {
		this.dragProxy 					= dragProxy;
		this.refusedBeforeDropEvent		= refusedBeforeDropEvent;
	}
	
	@Override
	protected void dispatch(IDragProxyHandler handler) {
		handler.onProxyRefusedBeforeDrop(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IDragProxyHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IDragProxy getDragProxy() {
		return dragProxy;
	}

	@Override
	public IRefusedBeforeDropEvent getRefusedBeforeDropEvent() {
		return refusedBeforeDropEvent;
	}


}
