/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.resizable;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizable;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Helper;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.RootPanel;

public class ResizableElementDefaultHandlers implements IResizableElementDefaultHandlers {
	
	private IResizable resizable;
	
	private ResizeUIHandler swRH;
	private ResizeUIHandler seRH;
	private ResizeUIHandler nwRH;
	private ResizeUIHandler neRH;
	
	private AbsolutePanel abPanel;
	
	public ResizableElementDefaultHandlers(IResizable resizableElement) {
		this.resizable = resizableElement;
		
		if (resizable.getUIPanel() instanceof UIPanel){
		
			this.abPanel   = Helper.getAbsolutePanel(resizable); 
		
		}else{
			throw new IllegalStateException("UIPanel is not instance of "+AbsolutePanel.class+ " cannot add resizable handler to UIPanel.");
		}
	
	}
	
	
	@Override
	public void attachDefaultHandlers() {
		
		resizable.getUIPanel().addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				
				if (removeElementEvent.getRemovedElement().equals(resizable)){
					
					abPanel.remove(seRH);
					
				}
				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {}
		
		});
		
		
		
		//add resize ui handlers on the specified position
		if (resizable.isResizableOnSouthEast()){
			
			this.seRH = new ResizeUIHandler(resizable);
			this.abPanel.add(seRH);
		}
		
		if (resizable.isResizableOnSouthWest()){
			
			this.swRH = new ResizeUIHandler(resizable);
			
		}
		
		if (resizable.isResizableOnNorthEast()){
			
			this.neRH = new ResizeUIHandler(resizable);
		
		}
		
		if (resizable.isResizableOnNorthWest()){
			
			this.nwRH = new ResizeUIHandler(resizable);
			
		}
		
		//for the first time refresh position
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			
			@Override
			public void execute() {

				refreshUIHandlersPositions();

			}
		});
		
		//if resizable is an instance of draggable
		//we must refresh uihandlers positions each time drag stops
		if (resizable instanceof IDraggableElement){
			
			IDraggableElement draggableResizable = (IDraggableElement) resizable;
			
			draggableResizable.addDragHandler(new DragHandler() {
				@Override
				public void onStop(IDragStopEvent event) {
					
					refreshUIHandlersPositions();
				}
				@Override
				public void onStart(IDragStartEvent event) {}
				@Override
				public void onMove(IDragMoveEvent event) {
					
					refreshUIHandlersPositions();
					
				}
				@Override
				public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
					// TODO Auto-generated method stub
					
				}
				@Override
				public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
					// TODO Auto-generated method stub
					
				}
				@Override
				public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
					// TODO Auto-generated method stub
					
				}
				@Override
				public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
					// TODO Auto-generated method stub
					
				}
			});
			
		}
		
		
	}
	
	public void refreshUIHandlersPositions(){
		
		if (swRH!=null){
			RootPanel.get().setWidgetPosition(swRH,(int) resizable.getSouthWestPoint().getX(), (int)resizable.getSouthWestPoint().getY());
		}
		
		if (seRH!=null){
			abPanel.setWidgetPosition(seRH,(int) (resizable.getSouthEastPoint().getX()-resizable.getUIPanel().getAbsoluteLeft()+resizable.getUIPanel().getScrollLeft()-10), (int)(resizable.getSouthEastPoint().getY()-resizable.getUIPanel().getAbsoluteTop()+resizable.getUIPanel().getScrollTop()-10));
		}
		
		if (nwRH!=null){
			RootPanel.get().setWidgetPosition(nwRH,(int) resizable.getNorthWestPoint().getX(), (int)resizable.getNorthWestPoint().getY());
		}
		
		if (neRH!=null){
			RootPanel.get().setWidgetPosition(neRH,(int) resizable.getNorthEastPoint().getX(), (int)resizable.getNorthEastPoint().getY());	
		}
		
	}

	@Override
	public IUIElement getUIElement() {
		return (IUIElement) resizable;
	}

}
