/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IPanelDragDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.GlobalDragData;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragStartEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;

public class UIPanelDragDefaultHandlers implements IPanelDragDefaultHandlers {

	private IUIPanel uipanel;

	private boolean dragging;

	public UIPanelDragDefaultHandlers(IUIPanel uipanel) {
		this.uipanel = uipanel;
	}

	@Override
	public void attachDefaultHandlers() {
		
		//if we're dragging while scrolling => adjust dragged element position
//		this.uipanel.addScrollHandler(new ScrollHandler() {
//		
//		@Override
//		public void onScroll(ScrollEvent event) {
//			
//			if (GlobalDragData.currentDraggedElement !=null){
//				
//				GlobalDragData.currentDraggedElement.setRelativeX(GlobalDragData.currentDraggedElement.getRelativeX()
//						+ uipanel.getScrollLeft());
//				GlobalDragData.currentDraggedElement.setRelativeY(GlobalDragData.currentDraggedElement.getRelativeY()
//						+ uipanel.getScrollTop());				
//			}
//			
//		}
//	});
		
		
		this.uipanel.addMouseMoveHandler(new MouseMoveHandler() {

			@Override
			public void onMouseMove(MouseMoveEvent event) {
				
				

				if (GlobalDragData.currentDraggedElement != null) {

					IDraggableElement draggable = GlobalDragData.currentDraggedElement;
					
					int relMouseX = event.getClientX() - draggable.getContainer().getAbsoluteLeft();
					int relMouseY = event.getClientY() - draggable.getContainer().getAbsoluteTop();
					


					if (draggable.getMouseState().isMouseDown()) {

						if (dragging == false) {
							
							draggable.fireEvent(new DragStartEvent());
							draggable.getUIPanel().getDDManager()
									.dragStartElement(draggable);
						}

						// fire drag move event
						draggable.fireEvent(new DragMoveEvent(new Float(
								GlobalDragData.dragStartInitialX), new Float(
								GlobalDragData.dragStartInitialY)));
						
	
						//inform DDManager that current draggable is moving
						//so that current draggable can eventually be dropped
						draggable.getUIPanel().getDDManager().draggingElement(draggable, event.getClientX(),event.getClientY());
						
						float newX = relMouseX-GlobalDragData.dragXdelta;
						float newY = relMouseY-GlobalDragData.dragYdelta; 
						
							draggable.setRelativeX(newX+draggable.getContainer().getScrollLeft());
							draggable.setRelativeY(newY+draggable.getContainer().getScrollTop());
						
						
						dragging = true;
						

					}

				}
			}
		});

		this.uipanel.addMouseUpHandler(new MouseUpHandler() {

			@Override
			public void onMouseUp(MouseUpEvent arg0) {
				
				dragging = false;
				
				if (GlobalDragData.currentDraggedElement!=null){
		
					GlobalDragData.currentDraggedElement.fireEvent(new DragStopEvent(new Float(GlobalDragData.dragStartInitialX),new Float(GlobalDragData.dragStartInitialY)));
					
					
					int actualMouseAbsoluteX = arg0.getClientX();
					int actualMouseAbsoluteY = arg0.getClientY();

					
					GlobalDragData.currentDraggedElement.getUIPanel().getDDManager().releasingDragElement(GlobalDragData.currentDraggedElement, actualMouseAbsoluteX,actualMouseAbsoluteY);
					
				}
				
				GlobalDragData.initialize();
			}

		});
		
		this.uipanel.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				
				GlobalDragData.UIPanelHasMouseOut = true;
				
			}
		});
		
		
		this.uipanel.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				
				GlobalDragData.UIPanelHasMouseOut = false;
				
			}
		});
		
	}

	@Override
	public IUIPanel getUIPanel() {
		return uipanel;
	}

}
