/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IHasUIPanelResizeUIHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.ResizeRequestEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;

public class UIPanelResizeDefaultHandlers implements IUIPanelResizeDefaultHandler{
	
	private IUIPanel panel;
	private int actualHeight;
	private int actualWidth;
	private int decreaseSize;
	private int increaseSize;
	private int maxHeight;
	private int maxWidth;
	private int minHeight;
	private int minWidth;
	private IHasUIPanelResizeUIHandlers rp;
	
	public UIPanelResizeDefaultHandlers(IUIPanel panel) {
		this.panel = panel;
	}
	
	@Override
	public void attachDefaultHandlers() {
		
		if (panel instanceof IHasUIPanelResizeUIHandlers){
			
			this.rp = (IHasUIPanelResizeUIHandlers) panel;
			
			this.actualHeight 	= rp.getResizeConfiguration().getActualHeight();
			this.actualWidth 	= rp.getResizeConfiguration().getActualWidth();
			this.decreaseSize 	= rp.getResizeConfiguration().getDecreaseSize();
			this.increaseSize	= rp.getResizeConfiguration().getIncreaseSize();
			this.maxHeight		= rp.getResizeConfiguration().getMaxHeight();
			this.maxWidth		= rp.getResizeConfiguration().getMaxWidth();
			this.minHeight		= rp.getResizeConfiguration().getMinHeight();
			this.minWidth		= rp.getResizeConfiguration().getMinWidth();
			
			
			processIncreaseDescreaseVisibility();
			
			
			//add resize action on each btns
			
			////:::::INCREASE
			
				//TOP
				rp.getTopResizeHandler().getIncreaseBtn().addClickHandler(new ClickHandler() {
				
					@Override
					public void onClick(ClickEvent event) {

						
						if (actualHeight<maxHeight){
							rp.getTopResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									increaseSize,
									0,
									0));
						}
						

						rp.getTopResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
			
				//BOTTOM
				rp.getBottomResizeHandler().getIncreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						
						if (actualHeight<maxHeight){
							rp.getBottomResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									increaseSize,
									0,
									0));
						}

						rp.getBottomResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
				
				//LEFT
				rp.getLeftResizeHandler().getIncreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						
						if (actualWidth<maxWidth){
							rp.getLeftResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									increaseSize,
									0,
									0,
									0));
						}					

						rp.getLeftResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
					
			
				});
				
				//RIGHT
				rp.getRightResizeHandler().getIncreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {

						if (actualWidth<maxWidth){
							rp.getRightResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									increaseSize,
									0,
									0,
									0));
						}

						rp.getRightResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
				
				
			////:::::DECREASE			
				
				//TOP
				rp.getTopResizeHandler().getDecreaseBtn().addClickHandler(new ClickHandler() {
				
					@Override
					public void onClick(ClickEvent event) {
						
						if (actualHeight>minHeight){
							rp.getTopResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									0,
									0,
									decreaseSize));
						}	
						

						rp.getTopResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
			
				//BOTTOM
				rp.getBottomResizeHandler().getDecreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {

						if (actualHeight>minHeight){
							rp.getBottomResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									0,
									0,
									decreaseSize));
						}	

						rp.getBottomResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
				
				//LEFT
				rp.getLeftResizeHandler().getDecreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						if (actualWidth>minWidth){
							rp.getLeftResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									0,
									decreaseSize,
									0));
						}

						rp.getLeftResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});
				
				//RIGHT
				rp.getRightResizeHandler().getDecreaseBtn().addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						
						if (actualWidth>minWidth){
							rp.getRightResizeHandler().hide();
							panel.fireEvent(new ResizeRequestEvent(
									0,
									0,
									decreaseSize,
									0));
						}	
				
						rp.getRightResizeHandler().refresh();
						processIncreaseDescreaseVisibility();
					}
			
				});				
				
				
			//Hide and show ResizeHandlers
			panel.addMouseMoveHandler(new MouseMoveHandler() {
				
				@Override
				public void onMouseMove(MouseMoveEvent event) {
						
					//TOP
					
					if (rp.getTopRegion().contains(new Point(event.getRelativeX(event.getRelativeElement()),event.getRelativeY(event.getRelativeElement())))){
						
						rp.refreshUIHandlers();
						rp.getTopResizeHandler().show();
						
					}else{
						
						rp.getTopResizeHandler().hide();
						
					}
					
					//BOTTOM
					
					if (rp.getBottomRegion().contains(new Point(event.getRelativeX(event.getRelativeElement()),event.getRelativeY(event.getRelativeElement())))){
						
						rp.refreshUIHandlers();
						rp.getBottomResizeHandler().show();
						
					}else{
						
						rp.getBottomResizeHandler().hide();
						
					}
					
					
					//LEFT
					
					if (rp.getLeftRegion().contains(new Point(event.getRelativeX(event.getRelativeElement()),event.getRelativeY(event.getRelativeElement())))){
						
						rp.refreshUIHandlers();
						rp.getLeftResizeHandler().show();
						
					}else{
						
						rp.getLeftResizeHandler().hide();
						
					}
					
					
					//RIGHT
					
					if (rp.getRightRegion().contains(new Point(event.getRelativeX(event.getRelativeElement()),event.getRelativeY(event.getRelativeElement())))){
						
						rp.refreshUIHandlers();
						rp.getRightResizeHandler().show();
						
					}else{
						
						rp.getRightResizeHandler().hide();
						
					}
					
					
				}
			});
			
			
			
			
			
			
			
			
		}
		
	}
	
	
	private void processIncreaseDescreaseVisibility(){
		
		this.actualHeight 	= rp.getResizeConfiguration().getActualHeight();
		this.actualWidth 	= rp.getResizeConfiguration().getActualWidth();
		
		//Handle decrease btns
		if (actualHeight<=minHeight){
			rp.getTopResizeHandler().hideDecreaseBtn();
			rp.getBottomResizeHandler().hideDecreaseBtn();
		}else{
			rp.getTopResizeHandler().showDecreaseBtn();
			rp.getBottomResizeHandler().showDecreaseBtn();
		}
		
		if (actualWidth<=minWidth){
			rp.getLeftResizeHandler().hideDecreaseBtn();
			rp.getRightResizeHandler().hideDecreaseBtn();
		}else{
			rp.getLeftResizeHandler().showDecreaseBtn();
			rp.getRightResizeHandler().showDecreaseBtn();
		}
		
		//Handle increase btns
		if (actualHeight>=maxHeight){
			rp.getTopResizeHandler().hideIncreaseBtn();
			rp.getBottomResizeHandler().hideIncreaseBtn();
		}else{
			rp.getTopResizeHandler().showIncreaseBtn();
			rp.getBottomResizeHandler().showIncreaseBtn();			
		}
		
		if (actualWidth>=maxWidth){
			rp.getLeftResizeHandler().hideIncreaseBtn();
			rp.getRightResizeHandler().hideIncreaseBtn();
		}else{
			rp.getLeftResizeHandler().showIncreaseBtn();
			rp.getRightResizeHandler().showIncreaseBtn();			
		}
		
	}

	@Override
	public IUIPanel getUIPanel() {
		return panel;
	}

}
