/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IAddWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IDisconnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

public class DisconnectionEvent extends GwtEvent<ConnectorHandler> implements IDisconnectionEvent {
	
	public static Type<ConnectorHandler> TYPE = new Type<ConnectorHandler>();
	

	private IConnectableElement disconnectedSource;
	private IConnectableElement disconnectedTarget;
	
	
	public DisconnectionEvent(IConnectableElement disconnectedSource, IConnectableElement disconnectedTarget) {
		

		this.disconnectedSource		= disconnectedSource;
		this.disconnectedTarget		= disconnectedTarget;
	}
	
	@Override
	protected void dispatch(ConnectorHandler handler) {
		handler.onDisconnection(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<ConnectorHandler> getAssociatedType() {
		return TYPE;
	}



	@Override
	public IConnectableElement getDisconnectedSource() {
		return disconnectedSource;
	}

	@Override
	public IConnectableElement getDisconnectedTarget() {
		return disconnectedTarget;
	}





}
