/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.selectable;


import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.events.ISelectionHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIElement;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectionHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.UnselectEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;

public abstract class Selectable extends UIElement implements ISelectable{
	
	private SelectableDefaultHandlers selectableDefaultHandler;
	
	public Selectable(IUIPanel uiPanel, String id) {
		super(uiPanel, id);
		
		//make current element selectable
		this.selectableDefaultHandler = new SelectableDefaultHandlers(this);
		this.selectableDefaultHandler.attachDefaultHandlers();
	}

	@Override
	public void addSelectionHandler(ISelectionHandler handler) {
		handlerManager.addHandler(SelectEvent.TYPE, (SelectionHandler)handler);
		handlerManager.addHandler(UnselectEvent.TYPE,(SelectionHandler)handler);
	}


	@Override
	public ISelectableDefaultHandlers getSelectableDefaultHandlers() {
		return this.selectableDefaultHandler;
	}

	
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}


}
