/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.notification;

import com.ebmwebsourcing.geasytools.widgets.ext.api.notification.INotificationBubbleConfiguration;

public class NotificationBubbleConfiguration implements INotificationBubbleConfiguration{
	

	private int defaultHeight;
	private int defaultWidth;
	private int indicatorLeftPosition;
	private int sideImageHeight;
	private int sideImageWidth;
	private int indicatorWidth;
	private int indicatorHeight;
	
	public NotificationBubbleConfiguration() {
		
		defaultHeight = 50;
		defaultWidth = 50;
		sideImageHeight = 16;
		sideImageWidth = 16;
		indicatorWidth = 20;
		indicatorHeight = 14;
	}
	
	


	@Override
	public int getBubbleIndicatorLeftPosition() {
		return indicatorLeftPosition;
	}

	@Override
	public int getDefaultHeight() {
		return defaultHeight;
	}

	@Override
	public int getDefaultWidth() {
		return defaultWidth;
	}
	

	@Override
	public int getSideImagesHeight() {
		return sideImageHeight;
	}

	@Override
	public int getSideImagesWidth() {
		return sideImageWidth;
	}

	public int getIndicatorHeight() {
		return indicatorHeight;
	}
	
	public int getIndicatorWidth() {
		return indicatorWidth;
	}

}
