/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.tabpanel.event;

import com.ebmwebsourcing.geasytools.widgets.core.api.panel.IPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.event.IPanelSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.event.ITabPanelHandler;
import com.google.gwt.event.shared.GwtEvent;

public class PanelSelectedEvent extends GwtEvent<ITabPanelHandler> implements IPanelSelectedEvent{
	
	
	private IPanel panel;

	public static Type<ITabPanelHandler> TYPE = new Type<ITabPanelHandler>();
	
	public PanelSelectedEvent(IPanel panel) {
		this.panel = panel;
	}
	
	@Override
	protected void dispatch(ITabPanelHandler handler) {
		handler.onPanelSelected(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<ITabPanelHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IPanel getPanel() {
		return panel;
	}

}
