/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard;



import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.BackEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.CancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.FinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.LoadEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.NextEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractWizard extends Composite implements IWizard{

	private HandlerManager handlerManager;
	private List<IFrame> frames;
	
	private int actualFramePointer;
	private int framesNb;
	
	public AbstractWizard() {
		
		
		this.handlerManager = new HandlerManager(this);
		this.framesNb = -1;
		this.frames = new ArrayList<IFrame>();
		
		getBackBtn().disable();
		getNextBtn().disable();
		
		addListenersOnBtns();
		

	}
	
	@Override
	public List<IFrame> getFrames() {
		return frames;
	}
	
	private void addListenersOnBtns(){
		
		this.getBackBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				if (actualFramePointer>0){
					
					actualFramePointer--;
					
					showFrame(actualFramePointer);
					
					IFrame nextFrame = null;
					
					if (actualFramePointer+1<=framesNb) nextFrame = frames.get(actualFramePointer+1);
					
					fireEvent(new BackEvent(frames.get(actualFramePointer), nextFrame));
				}
				
				if (actualFramePointer-1<0)  getBackBtn().disable();
				
				if (actualFramePointer<framesNb) getNextBtn().enable();
				
			}
		});
		
		this.getNextBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				if (actualFramePointer<framesNb){
					
					actualFramePointer++;
					
					showFrame(actualFramePointer);
					
					IFrame previousFrame = null;
					
					if (actualFramePointer-1>=0) previousFrame = frames.get(actualFramePointer-1); 
					
					fireEvent(new NextEvent(frames.get(actualFramePointer), previousFrame));
				}
				
				if (actualFramePointer+1>framesNb)  getNextBtn().disable();
				
				if (actualFramePointer>0) getBackBtn().enable();
			}
		});
		
		
		this.getCancelBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				fireEvent(new CancelEvent());
				
			}
		});
		
		this.getFinishBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				fireEvent(new FinishEvent());
				
			}
		});
		
		

	}
	

	
	private void showFrame(int f){
		
		//hide every frames
		for(IFrame fr:frames){
			fr.hide();
		}
		
		
		//and show the selected one
		this.frames.get(f).show();
		
		
	}
	
	

	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
	@Override
	public void setFrames(List<IFrame> frames) {
		
		this.framesNb  = frames.size();
		
		this.frames.addAll(frames);
		initialize();
	}
	
	
	@Override
	public void addHandler(IWizardHandler handler) {
		handlerManager.addHandler(LoadEvent.TYPE, handler);
		handlerManager.addHandler(BackEvent.TYPE, handler);
		handlerManager.addHandler(CancelEvent.TYPE, handler);
		handlerManager.addHandler(FinishEvent.TYPE, handler);
		handlerManager.addHandler(NextEvent.TYPE, handler);
	}

	@Override
	public void initialize() {
		
		this.actualFramePointer = 0;
		this.getBackBtn().disable();
		if (framesNb>1) getNextBtn().enable(); 
		
		showFrame(actualFramePointer);
		
		fireEvent(new LoadEvent());
	}
}
