/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file;

import java.util.HashMap;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;

public class Folder implements IFolder{
	
	private HashSet<IFolder> children;
	private IFolder parent;
	private String name;
	private HashMap<String, Object> attributes;
	public Folder() {
		
		this.children = new HashSet<IFolder>();
		this.attributes = new HashMap<String, Object>();
	}
	
	public Folder(String name){
		this();
		this.name = name;
	}
	
	@Override
	public void addFolder(IFolder folder) {
		this.children.add(folder);
		folder.setParent(this);
	}

	@Override
	public HashSet<IFolder> getChildren() {
		return children;
	}

	@Override
	public String getIcoUrl() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IFolder getParent() {
		return parent;
	}


	@Override
	public void setParent(IFolder folder) {
		this.parent = folder;
	}


	@Override
	public String getName() {
		return name;
	}


	@Override
	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public Object getValue(String attributeName) {
		return attributes.get(attributeName);
	}

	@Override
	public void setAttribute(String attributeName, Object value) {
		attributes.put(attributeName, value);
	}

}
