/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event;

import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.INextEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.google.gwt.event.shared.GwtEvent;

public class NextEvent extends GwtEvent<IWizardHandler> implements INextEvent{
	
	private IFrame actualFrame;
	private IFrame previousFrame;
	
	public static Type<IWizardHandler> TYPE = new Type<IWizardHandler>();
	
	public NextEvent(IFrame actualFrame,IFrame previousFrame) {
		
		this.actualFrame = actualFrame;
		this.previousFrame = previousFrame;
		
	}
	
	@Override
	protected void dispatch(IWizardHandler handler) {
		handler.onNext(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IWizardHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IFrame getActualFrame() {
		return actualFrame;
	}

	@Override
	public IFrame getPreviousFrame() {
		return previousFrame;
	}

}
