/**
 * webeditor-dao - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.xstream;

import com.ebmwebsourcing.webeditor.api.IUserDao;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;

public class UserDao extends AbstractDao<IUser> implements IUserDao{

	@Override
	public IUser getUserById(String id) {
		
		for(IUser u:this.getSpace()){
			
			if (u.getId().equals(id)){
				
				return u;

			}
			
		}
		
		
		return null;
	}

	@Override
	protected String getSpaceName() {
		return "users";
	}

	@Override
	public void addUser(IUser user) {
		
		if (this.getSpace().contains(user)==false) getSpace().add(user);
		
	}

	@Override
	protected void update(IUser object) {
		// TODO Auto-generated method stub
		
	}

}
