/**
 * webeditor-file-repository - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywebeditor.server.file.repository;

import java.util.Map;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.exception.FileRepositoryInquiryException;
import com.ebmwebsourcing.geasywebeditor.client.file.repository.to.SearchFormData;


public interface FileRepositoryInquiryService {
	
	/**
	 * Tests that the server can be used to perform the search and to
	 * retrieve the files operational and correspond to the wanted services
	 * Just do nothing if you do not need to check any remote server.
	 * 
	 * @param repoAddress A String describing the repository address : URL, host:port...
	 * @throws FileRepositoryInquiryException if the service cannot be called correctly
	 */
	public void testServerCompliance(String repoAddress) throws FileRepositoryInquiryException;

	
	/**
	 * Performs a search on the file repository with the given search phrase and the given
	 * search criteria.
	 * 
	 * @param repoAddress A String describing the repository address : URL, host:port...
	 * @param data the data used to perform the search
	 * @return A mapping : Map<name of the service, id of the service>
	 * @throws FileRepositoryInquiryException
	 */
	public Map<String,String> searchFile(String repoAddress, SearchFormData data) throws FileRepositoryInquiryException;
	
	
	/**
	 * Retrieves the content of a file as a String from the file repository
	 * @param repoAddress A String describing the repository address : URL, host:port...
	 * @param serviceId The id of the wanted file
	 * @return The file content as a String
	 * @throws FileRepositoryInquiryException
	 */
	public String getFileContentAsString(String repoAddress, String serviceId) throws FileRepositoryInquiryException;
	
	
}
