/**
 * webeditor-file-repository - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywebeditor.client.file.repository;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.ui.SearchForm;



public abstract class FileRepositoryDescription{

	private String fileFormat;
	private String fileFormatDisplayName;
	private String displayName;
	/**
	 * Qualified name of the class as a String 
	 * A String is used because Class<T> is not possible in this case because T 
	 * must be an instance of FileRepositoryInquiryService which is a server side class
	 */
	private String fileRepositoryInquiryService;
	
	//optional : may be null
	private String urlExample;
	

	/**
	 * Do not use, it is only for serialization
	 */
	protected FileRepositoryDescription(){}
	
	
	
	public FileRepositoryDescription(String fileFormat, String displayName, String fileRepositoryInquiryService,
			String urlExample) {
		
		this(fileFormat, displayName,fileRepositoryInquiryService);
		this.urlExample = urlExample;
	}
	
	
	
	public FileRepositoryDescription(String fileFormat, String displayName, String fileRepositoryInquiryService) {
		super();
		
		this.fileFormat = fileFormat;
		this.fileFormatDisplayName = fileFormat.toUpperCase();
		this.displayName = displayName;
		this.fileRepositoryInquiryService = fileRepositoryInquiryService;
	}

	
	public String getAddressExample() {
		return urlExample;
	}

	public abstract SearchForm getSearchForm();

	public String getDisplayName() {
		return displayName;
	}

	public String getFileRepositoryInquiryService() {
		return fileRepositoryInquiryService;
	}

	public String getFileFormat() {
		return fileFormat;
	}

	public String getFileFormatDisplayName() {
		return fileFormatDisplayName;
	}
	
}
