/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.content;

import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.content.IDefaultRequestContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IContentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.request.IGetSelectedContentElementsRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.response.IGetSelectedContentElementsResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestEvent;

public class DefaultRequestContentHandler implements IDefaultRequestContentHandler{
	
	private IContentManager contentManager;
	
	public DefaultRequestContentHandler(IContentManager contentManager) {
		this.contentManager = contentManager;
	}
	
	@Override
	public IContentManager getContentManager() {
		return contentManager;
	}

	@Override
	public void onRequest(IRequestEvent event) {
		
		if (event.getRequest() instanceof IGetSelectedContentElementsRequest){
			
			IGetSelectedContentElementsResponseHandler rh = (IGetSelectedContentElementsResponseHandler) event.getResponseHandler();
			
			rh.receiveResponse(contentManager.getContentElements());
			
		}
		
		
	}

}
