/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.AbstractCommonPresentersTest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ExportProjectPresenter;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.FinishEvent;
import com.google.gwt.event.logical.shared.PublicValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasValue;
import junit.framework.Assert;
import net.customware.gwt.presenter.client.place.PlaceParsingException;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.place.PlaceRequestEvent;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class ExportProjectPresenterTest
extends AbstractCommonPresentersTest {
    private IExportProjectConfigurationView displayMock;
    private ExportProjectPresenter presenter;
    private HasValue<String> exportFormatDescriptionMock;
    private boolean configurationCompleteCalled = false;

    @Before
    public void initMocksAndExpectations() {
        this.displayMock = (IExportProjectConfigurationView)EasyMock.createMock(IExportProjectConfigurationView.class);
        this.exportFormatDescriptionMock = (HasValue)EasyMock.createMock(HasValue.class);
        EasyMock.expect((Object)this.displayMock.getExportFormat()).andReturn((Object)this.comboboxMock).anyTimes();
        EasyMock.expect((Object)this.displayMock.getWizard()).andReturn((Object)this.wizardMock);
        EasyMock.expect((Object)this.displayMock.getExportFormatDescription()).andReturn(this.exportFormatDescriptionMock);
        EasyMock.expect((Object)this.displayMock.getActualProject()).andReturn(EasyMock.createMock(HasValue.class)).anyTimes();
        this.displayMock.open();
        this.displayMock.refresh();
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        EasyMock.expect((Object)this.projectInstanceMock.getProjectType()).andReturn((Object)this.projectTypeMock).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.projectInstanceMock});
        this.exportFormatDescriptionMock.setValue(EasyMock.isA(String.class));
        EasyMock.replay((Object[])new Object[]{this.exportFormatDescriptionMock});
        this.presenter = new ExportProjectPresenter(this.displayMock, this.eventBus);
        this.presenter.bind();
    }

    @Test
    public void testHasActualProjectInstanceOnRevealed_AndDisplaysView_AndHasExportFormats() throws PlaceParsingException {
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        EasyMock.expect((Object)this.displayMock.getExportFormat()).andReturn((Object)this.comboboxMock).anyTimes();
        EasyMock.expect((Object)this.displayMock.getActualProject()).andReturn(EasyMock.createMock(HasValue.class)).anyTimes();
        this.displayMock.open();
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        String req = ExportProjectPresenter.PLACE.getId();
        this.eventBus.fireEvent((GwtEvent)new PlaceRequestEvent(PlaceRequest.fromString((String)req)));
        Assert.assertEquals((Object)this.projectInstanceMock, (Object)this.presenter.getActualProjectInstance());
        Assert.assertEquals((Object)this.exportFormats, (Object)this.presenter.getCurrentExportFormats());
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }

    @Test
    public void testProjectExportFormatSelection_AndClickOnFinish_FiresExportFormatConfiguraitonComplete() {
        this.comboboxValueChangeHandler.onValueChange((ValueChangeEvent)new PublicValueChangeEvent(this.exportFormats.get(0)));
        Assert.assertNotNull((Object)this.presenter.getSelectedExportFormat());
        EasyMock.verify((Object[])new Object[]{this.exportFormatDescriptionMock});
        this.eventBus.addProjectConfigurationHandler(new IProjectConfigurationHandler(){

            public void onConfigurationComplete(IProjectConfigurationCompleteEvent event) {
                if (event instanceof IExportProjectConfigurationCompleteEvent) {
                    IExportProjectConfigurationCompleteEvent e = (IExportProjectConfigurationCompleteEvent)event;
                    Assert.assertEquals((Object)ExportProjectPresenterTest.this.presenter.getActualProjectInstance(), (Object)e.getProjectInstance());
                    Assert.assertEquals((Object)ExportProjectPresenterTest.this.presenter.getSelectedExportFormat(), (Object)e.getFormat());
                    ExportProjectPresenterTest.this.configurationCompleteCalled = true;
                }
            }
        });
        this.wizardHandler.onFinish((IFinishEvent)new FinishEvent());
        Assert.assertTrue((boolean)this.configurationCompleteCalled);
    }
}

