/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IComponentHideEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IMultipleComponentPlaceHolderHandler;
import com.google.gwt.event.shared.GwtEvent;

public class ComponentHideEvent extends GwtEvent<IMultipleComponentPlaceHolderHandler> implements IComponentHideEvent{

	private IComponent component;
	
	public static Type<IMultipleComponentPlaceHolderHandler> TYPE = new Type<IMultipleComponentPlaceHolderHandler>(); 
	
	public ComponentHideEvent(IComponent component) {
		this.component = component;
	}
	
	@Override
	protected void dispatch(IMultipleComponentPlaceHolderHandler handler) {
		handler.onComponentHide(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IMultipleComponentPlaceHolderHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IComponent getComponent() {
		return component;
	}

}
