/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import java.util.ArrayList;
import java.util.List;

import net.customware.gwt.presenter.client.EventBus;
import net.customware.gwt.presenter.client.place.Place;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.widget.WidgetPresenter;

import com.ebmwebsourcing.geasytools.webeditor.api.components.response.IGetEditConfigurationPanelsByProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.presenter.IEditProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetOpenedProjectInstancesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.request.GetEditConfigurationPanelsByProjectType;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.EditProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetOpenedProjectInstancesRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectConfigurationData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;

public class EditProjectPresenter extends WidgetPresenter<IEditProjectConfigurationView> implements IEditProjectPresenter{
	
	public static final Place PLACE = new Place("Edit.Project");
	
	public static final String PROJECT_ID_PARAM = "projectId";
	
	private String projectId;
	
	private IProjectInstance actualProjectInstance;
	private List<IEditConfigurationPanel> configurationPanels;
	private List<IProjectInstance> openedProjects;
	
	private IEditorEventBus eventBus;
	
	private List<IEditConfigurationPanel> previouslyLoaded;
	
	private IEditConfigurationPanel projectConfigurationPanel;
	
	public EditProjectPresenter(IEditProjectConfigurationView display,
			EventBus eventBus) {
		super(display, eventBus);
		
		this.eventBus = (IEditorEventBus) eventBus;
		this.configurationPanels = new ArrayList<IEditConfigurationPanel>();

		
	}

	@Override
	public Place getPlace() {
		return PLACE;
	}

	@Override
	protected void onBind() {
		
		projectConfigurationPanel = display.getProjectConfigurationPanel();
		getDisplay().getComplexTabPanel().addPanel(projectConfigurationPanel);
		
		
		getDisplay().getCancelButton().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				//sending no data means => do not commit changes
				eventBus.fireEvent(new EditProjectConfigurationCompleteEvent());
				
			}
		});
		
		getDisplay().getOkButton().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {

				//TODO: should return every configuration data of every panel and send them
				ArrayList<IProjectConfigurationData> list = new ArrayList<IProjectConfigurationData>();
				
				IProjectConfigurationData pData = projectConfigurationPanel.onValidate();
				
				list.add(pData);
				
				eventBus.fireEvent(new EditProjectConfigurationCompleteEvent(actualProjectInstance,list));
				
			}
		});
		
		
	}

	@Override
	protected void onPlaceRequest(PlaceRequest request) {
		
		projectId = request.getParameter(PROJECT_ID_PARAM, null);
		
		if (projectId!=null){
		
				//lets search in opened project instance		
				eventBus.fireEvent(new RequestEvent(new GetOpenedProjectInstancesRequest(),new IGetOpenedProjectInstancesResponseHandler() {
						
						@Override
						public void receiveResponse(List<IProjectInstance> result) {
							
							
							for(IProjectInstance instance:result){
							    
								if (instance.getId().equals(projectId)){
									actualProjectInstance = instance;
								}
								
							}
							
						}
				}));
					
				//if projectInstance is null => means that user just opened editor with actual place url, but
				//did not opened the project first
				if (actualProjectInstance!=null){
					
					//load / reload project panel 
					projectConfigurationPanel.onLoad(actualProjectInstance);
					
					eventBus.fireEvent(new RequestEvent(new GetEditConfigurationPanelsByProjectType(actualProjectInstance), new IGetEditConfigurationPanelsByProjectInstanceResponseHandler() {
						
						@Override
						public void receiveResponse(List<IEditConfigurationPanel> result) {
							
							configurationPanels = result;
							
							
							//hide previous panels
							if (previouslyLoaded!=null){
								for(IEditConfigurationPanel p : previouslyLoaded){
									getDisplay().removePanel(p);
								}								
							}
							previouslyLoaded = result;
							
							

							
							if (configurationPanels!=null){
								//add new panels
								for(IEditConfigurationPanel panel:configurationPanels){

									getDisplay().getComplexTabPanel().addPanel(panel);

									//load / refresh project instance on configuration panel
									panel.onLoad(actualProjectInstance);
									
								}
									
									//activate first panel
									getDisplay().getComplexTabPanel().activatePanel(projectConfigurationPanel);
									
									
								
									
							}
							
						}
					}));
					

					
				}else{
					
					//send error message
//					eventBus.fireEvent(new EditorErrorEvent("Project not open", "The requested project need to be open, in order to be edited. Please, open project first.", DefaultErrorLevel.INFO));

					//restore url
					History.newItem("");
					
				}
		}
	}

	@Override
	protected void onUnbind() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void refreshDisplay() {
		

		
	}

	@Override
	public void revealDisplay() {
		if (actualProjectInstance!=null){
			display.open();	
		}
	}

	@Override
	public String getProjectId() {
		return projectId;
	}

	@Override
	public List<IEditConfigurationPanel> getEditPanels() {

		return null;
	}

	@Override
	public IProjectInstance getActualProjectInstance() {
		return actualProjectInstance;
	}



}
