/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.project;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceLoader;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceMetaDataLoader;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceWriter;

public class ProjectClassLoaderService {
	
	private static ProjectClassLoaderService instance;
	
	private ProjectClassLoaderService(){
		
	}
	
	
	public static ProjectClassLoaderService getInstance(){
		
		if (instance==null){
			instance = new ProjectClassLoaderService();
		}
		
		return instance;
	}
	
	
	
	
	public IProjectInstanceLoader getInstanceLoader(String qname) throws ServiceException{
		
		
		try {
		
			Class<?> clzz = Class.forName(qname);

			IProjectInstanceLoader instanceLoader = (IProjectInstanceLoader) clzz.newInstance();
			
			
			return instanceLoader;
			
			
		} catch (ClassNotFoundException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
		
			
		} catch (InstantiationException e) {

			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
			
		
		} catch (IllegalAccessException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
			
		}
		
		
		
	}
	
	
	
	public IProjectInstanceMetaDataLoader getMetaDataLoader(String qname) throws ServiceException{
		

		try {
			Class<?> clzz;
			
			clzz = Class.forName(qname);
			
			IProjectInstanceMetaDataLoader metaDataLoader = (IProjectInstanceMetaDataLoader) clzz.newInstance();
		
			return metaDataLoader;
			
		} catch (ClassNotFoundException e) {

			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
		} catch (InstantiationException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
		} catch (IllegalAccessException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());

		}
		

		
		
	}

	
	
	
	public IProjectInstanceWriter getInstanceWriter(String qname) throws ServiceException{
		
		
		try {
		
			Class<?> clzz = Class.forName(qname);

			IProjectInstanceWriter instanceLoader = (IProjectInstanceWriter) clzz.newInstance();
			
			
			return instanceLoader;
			
			
		} catch (ClassNotFoundException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
		
			
		} catch (InstantiationException e) {

			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
			
		
		} catch (IllegalAccessException e) {
			
			e.printStackTrace();
			throw new ServiceException(e.getMessage());
			
			
		}
		
		
		
	}
	

	
	
}
