/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.shared.server.api.service.project;

import java.io.File;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;

public interface IProjectInstanceWriter {
	
	/**
	 * Write project instance into the actual project instance type format
	 * @param projectInstance
	 * @param formatToWriteIn
	 * @param outputDirectory
	 * @return
	 */
	File writeProjectFile(IProjectInstance projectInstance,File projectOutputDirectory) throws ServiceException;
	
	/**
	 * Write project instance file into the specified format
	 * @param projectInstanceFile
	 * @param formatToWriteIn
	 * @param outputDirectory
	 * @return
	 */
	File writeProjectFile(File projectInstanceFile,IProjectInstanceFormat formatToWriteIn,File temporaryOutputDirectory) throws ServiceException;

	/**
	 * Write project instance file into the specified format using the specified data
	 * @param projectFile
	 * @param exportData
	 * @param format
	 * @param directory
	 * @return
	 * @throws ServiceException
	 */
	File writeProjectFile(File projectFile, IProjectInstanceMetaData exportData, IProjectInstanceFormat format, File directory) throws ServiceException;

}
