/**
 * webeditor-ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.gwtextwidgets.input.ComboBox;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.Wizard;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.WizardFrame;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view.ProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.core.api.input.IComboBox;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.HTMLPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;
import com.gwtext.client.widgets.layout.HorizontalLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;

public class ExportProjectConfigurationView extends ProjectConfigurationView implements IExportProjectConfigurationView{
	
	private Wizard wizard;
	private Window window;
	private HasValue<String> exportFormatDescription;
	private Label exportFormatDescriptionLBL;
	private IComboBox<IProjectInstanceFormat> exportFormats;
	private HasValue<IProjectInstance> actualProject;
	private Label actualProjectNameLbl;
	private Label actualProjectTypeLbl;
	
	public ExportProjectConfigurationView() {
	
		this.exportFormatDescriptionLBL = new Label();
		this.window = new Window("Export Project");
		Panel headerPanel  = new HTMLPanel("<b>Export Project</b> <br> <span>Export actual project into the specified format</span>");
		headerPanel.setHeight(50);
		headerPanel.setMargins(0, 0, 0, 5);
		this.window.add(headerPanel);
		this.window.setCloseAction(Window.HIDE);
		this.window.setResizable(false);
		
		this.actualProjectNameLbl 		= new Label();
		this.actualProjectTypeLbl		= new Label();
		
		
		ArrayList<IFrame> frames = new ArrayList<IFrame>();
		frames.add(getFrame1());
		this.getWizard().setFrames(frames);
		window.add((Widget) getWizard());
		this.window.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onHide(Component component) {
				
				History.newItem("");
				
			}
			
		});
		
	}
	
	
	@Override
	public IComboBox<IProjectInstanceFormat> getExportFormat() {
		
		if (exportFormats==null){
			this.exportFormats = new ComboBox<IProjectInstanceFormat>();
		}
		
		return exportFormats;
	}

	@Override
	public HasValue<String> getExportFormatDescription() {
		
		if (exportFormatDescription==null){
			this.exportFormatDescription = new HasValue<String>() {
				
				@Override
				public void fireEvent(GwtEvent<?> event) {
					// TODO Auto-generated method stub
					
				}
				
				@Override
				public HandlerRegistration addValueChangeHandler(
						ValueChangeHandler<String> handler) {
					// TODO Auto-generated method stub
					return null;
				}
				
				@Override
				public void setValue(String value, boolean fireEvents) {
					

					
				}
				
				@Override
				public void setValue(String value) {
					
					exportFormatDescriptionLBL.setText(value);
					
				}
				
				@Override
				public String getValue() {
					// TODO Auto-generated method stub
					return null;
				}
			};
		}
		
		return exportFormatDescription;
	}

	@Override
	public IWizard getWizard() {
		
		if (wizard==null){
			this.wizard = new Wizard(650,100);
			((Wizard)this.wizard).setVisible(false);//bug: on instantiation wizard is added to rootpanel
		}
		
		return wizard;
	}

	@Override
	public void close() {
		
		this.window.hide();

		
	}

	@Override
	public void open() {
		
		((Wizard)this.wizard).setVisible(true);
		((ComboBox<?>)this.exportFormats).setVisible(true);
		window.show();
		
		
	}

	private WizardFrame getFrame1(){
		
		WizardFrame frame = new WizardFrame((Wizard) getWizard());
		
		
		Panel vp1 = new Panel();
		vp1.setLayout(new VerticalLayout(10));
		vp1.add(actualProjectNameLbl);
		vp1.add(actualProjectTypeLbl);
		
		Panel hp = new Panel();
		hp.setLayout(new HorizontalLayout(3));
		hp.add(new Label("Export format: "));
		hp.add((Widget) getExportFormat());
		
		vp1.add(hp);
		vp1.add(exportFormatDescriptionLBL);


		

		
		frame.add(vp1);
		
		
		return frame;
	}
	
	@Override
	public void refresh() {
		exportFormats.clearValue();
		exportFormatDescriptionLBL.setText("");
	}

	@Override
	public Widget asWidget() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void startProcessing() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void stopProcessing() {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public HasValue<IProjectInstance> getActualProject() {
		
		if (actualProject==null){
			this.actualProject = new HasValue<IProjectInstance>() {
				
				@Override
				public void fireEvent(GwtEvent<?> event) {
				
					
				}
				
				@Override
				public HandlerRegistration addValueChangeHandler(
						ValueChangeHandler<IProjectInstance> handler) {
				
					return null;
				}
				
				@Override
				public void setValue(IProjectInstance value, boolean fireEvents) {
				
					
				}
				
				@Override
				public void setValue(IProjectInstance value) {
					
					actualProjectNameLbl.setText("Actual project to export: "+value.getName());
					actualProjectTypeLbl.setText("Project type: "+value.getProjectType().getName());
				
				}
				
				@Override
				public IProjectInstance getValue() {
				
					return null;
				}
			};
		}
		
		return actualProject;
	}

}
