/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasywsdl.service.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.geasywsdl.domain.api.IDefinitions;
import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.ebmwebsourcing.geasywsdl.domain.api.IPort;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;
import com.ebmwebsourcing.geasywsdl.domain.api.IService;
import com.ebmwebsourcing.geasywsdl.service.serverToClient.DefinitionsParser;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

public class ServiceTest {
    private XmlContextFactory xmlContextFactory = new XmlContextFactory();
    private XmlContext xmlContext = this.xmlContextFactory.newContext();

    @Test
    public void testDefinitionsParser() throws XmlObjectReadException {
        URL defUrl = Thread.currentThread().getContextClassLoader().getResource("wsdl4test.wsdl");
        XmlObjectReader reader = this.xmlContext.createReader();
        Definitions def = (Definitions)reader.readDocument(defUrl, Definitions.class);
        Description desc = (Description)Factory.getInstance().wrap((XmlObject)def);
        Assert.assertNotNull((Object)desc);
        DefinitionsParser parser = new DefinitionsParser();
        IDefinitions iDef = parser.parseDefinitions(desc);
        Assert.assertNotNull((Object)iDef);
        Assert.assertEquals((String)"http://wsdl4test", (String)iDef.getTargetNamespace());
        Assert.assertEquals((int)1, (int)iDef.getServices().size());
        Assert.assertEquals((String)"service0", (String)((IService)iDef.getServices().iterator().next()).getName());
        Assert.assertEquals((int)1, (int)((IService)iDef.getServices().iterator().next()).getPorts().size());
        Assert.assertEquals((String)"port0", (String)((IPort)((IService)iDef.getServices().iterator().next()).getPorts().iterator().next()).getName());
        Assert.assertEquals((String)"binding0", (String)((IPort)((IService)iDef.getServices().iterator().next()).getPorts().iterator().next()).getBinding().getName());
        Assert.assertEquals((int)1, (int)((IPort)((IService)iDef.getServices().iterator().next()).getPorts().iterator().next()).getBinding().getOperations().size());
        Assert.assertEquals((int)1, (int)iDef.getPortTypes().size());
        Assert.assertEquals((int)5, (int)((IPortType)iDef.getPortTypes().iterator().next()).getOperations().size());
        for (IOperation op : ((IPortType)iDef.getPortTypes().iterator().next()).getOperations()) {
            if (!op.getName().equals("operation0")) continue;
            Assert.assertEquals((String)"element0", (String)op.getInput().getName());
            Assert.assertEquals((String)"element3", (String)op.getOutput().getName());
            break;
        }
    }
}

