/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.aop;

import com.ebmwebsourcing.webcommons.aop.annotation.NotNullParam;
import java.lang.annotation.Annotation;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CheckParameterNullityForServices {
    private final Logger logger = Logger.getLogger(this.getClass());

    @Pointcut(value="within(com.ebmwebsourcing.webcommons.user..*) && execution(public * *(..)) && @annotation(com.ebmwebsourcing.webcommons.aop.annotation.CheckAllArgumentsNotNull)")
    private void publicMethodAllArgsNotNull() {
    }

    @Pointcut(value="within(com.ebmwebsourcing.webcommons.user..*) && execution(public * *(..)) && @annotation(com.ebmwebsourcing.webcommons.aop.annotation.CheckArgumentsNotNull)")
    private void publicMethodSomeArgsNotNull() {
    }

    @Around(value="publicMethodAllArgsNotNull()")
    public Object beforePublicAllArgsNotNull(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                throw new NullPointerException("Arg " + i + " of method '" + pjp.getSignature().getName() + "' must not be null");
            }
        }
        return pjp.proceed();
    }

    @Around(value="publicMethodSomeArgsNotNull()")
    public Object beforePublicSomeArgsNotNull(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Annotation[][] argAnnots = methodSignature.getMethod().getParameterAnnotations();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annots = argAnnots[i];
                if (annots == null) continue;
                boolean annotFound = false;
                for (int j = 0; j < annots.length && !annotFound; ++j) {
                    if (!(annots[j] instanceof NotNullParam)) continue;
                    this.logger.debug((Object)("##### NotNullParam annotation found on arg " + i));
                    annotFound = true;
                    if (args[i] != null) continue;
                    throw new NullPointerException("Arg " + i + " of method '" + pjp.getSignature() + "' must not be null");
                }
            }
        }
        return pjp.proceed();
    }
}

