/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.service;

import com.ebmwebsourcing.webcommons.aop.annotation.CheckAllArgumentsNotNull;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.service.RoleManager;
import com.ebmwebsourcing.webcommons.user.api.to.RoleTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.Role;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class RoleManagerImpl
implements RoleManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private RoleDAO roleDAO;
    private Resource rolesResource;
    private RoleManager roleManager;

    public void nonTransactionalInit() throws IOException, RoleGroupException {
        this.logger.debug((Object)"###### Initialize RoleManager bean");
        this.roleManager.init();
        this.logger.debug((Object)"###### RoleManager bean initialized");
    }

    public void setRolesResource(Resource resource) {
        this.rolesResource = resource;
    }

    @Override
    public void init() throws IOException {
        Object[] roles;
        Properties rolesProps = PropertiesLoaderUtils.loadProperties((Resource)this.rolesResource);
        for (Object enumRole : roles = rolesProps.keySet().toArray(new Object[0])) {
            this.logger.debug((Object)("Create role : " + (String)enumRole));
            this.createRole((String)enumRole);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void createRole(String roleName) {
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            role = new Role();
            role.setName(roleName);
            this.roleDAO.save((Object)role);
        }
    }

    @Override
    public String[] getAllRoles() {
        ArrayList<String> stringRoles = new ArrayList<String>();
        List roles = this.roleDAO.getAll();
        for (Role role : roles) {
            stringRoles.add(role.getName());
        }
        return stringRoles.toArray(new String[0]);
    }

    @Override
    public List<RoleTO> getAll() {
        List allRolesBO = this.roleDAO.getAll();
        ArrayList<RoleTO> allRoles = new ArrayList<RoleTO>();
        for (Role r : allRolesBO) {
            RoleTO rTO = new RoleTO();
            rTO.setId(r.getId());
            rTO.setName(r.getName());
            allRoles.add(rTO);
        }
        return allRoles;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }
}

