/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.SchemaFactory;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSAddressingJAXBContext {
	
	private static final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(new Class[] {
    		com.ebmwebsourcing.wsstar.jaxb.addressing.ObjectFactory.class}));


    /**
     * The JAXB context
     */
    private static JAXBContext jaxbContext;

	/**
     * Private object initializations
     */
    public static void createDefaultContext() throws WSAddressingException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        try {

            WSAddressingJAXBContext.jaxbContext = JAXBContext
                    .newInstance(defaultObjectFactories.toArray(new Class[defaultObjectFactories.size()]));

        } catch (final JAXBException e) {
            throw new WSAddressingException(e);
        }

    }
    
    public static void createContextWithOtherObjectFactories(List<Class> addedObjectFactories) throws WSAddressingException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        List<Class> objectFactories = new ArrayList<Class>();
        objectFactories.addAll(defaultObjectFactories);
        if(addedObjectFactories != null) {
            objectFactories.addAll(addedObjectFactories);
        }
        try {
            WSAddressingJAXBContext.jaxbContext = JAXBContext
                    .newInstance(objectFactories.toArray(new Class[objectFactories.size()]));

        } catch (final JAXBException e) {
            throw new WSAddressingException(e);
        }

    }

    public static JAXBContext getJaxbContext() {
        return WSAddressingJAXBContext.jaxbContext;
    }
}
