/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.api.absitf;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.neethi.Policy;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaElement;

public interface AbsItfEndpointReferenceType<Ref extends AbsItfReferenceParametersType> extends SchemaElement {

    /**
     * Set the document base URI of this definition. Can be used to represent
     * the origin of the Definition, and can be exploited when resolving
     * relative URIs (e.g. in &lt;import&gt;s).
     *
     * @param documentBaseURI
     *            the document base URI of this definition
     */
    public void setDocumentBaseURI(URI documentBaseURI);

    /**
     * Get the document base URI of this definition.
     *
     * @return the document base URI
     */
    public URI getDocumentBaseURI();
	
	QName getTagQName();
	
	void setTagQName(QName name);
	
	String getAddress();
	
	void setAddress(String address);
	
	List<Policy> getPolicies();

	void setPolicy(List<Policy> policies) throws WSAddressingException;
	
	Ref getReferenceParameters() throws WSAddressingException;
	
	void setReferenceParameters(Ref ref) throws WSAddressingException;
	
	Ref newReferenceParameters() throws WSAddressingException;
}
