/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.definition.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.test.TestWSBaseNotificationDefinition;
import com.ebmwebsourcing.wsstar.notification.definition.test.Util;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestWSBrokeredNotificationDefinition
extends TestCase {
    private static final String DEFAULT_PETALS_ADDRESS = "http://petals.ow2.org/cdk";

    public void testReadRegisterPublisher() throws URISyntaxException, WSNotificationException, WSAddressingException {
        System.out.println("\n\t testReadRegisterPublisher() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/RegisterPublisher.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        RegisterPublisher descRP = WSNotificationReader.getInstance().readRegisterPublisher(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check RegisterPublisher attributs value : \n ");
        Assert.assertNotNull((Object)descRP);
        Assert.assertNotNull((Object)descRP.getTopic());
        Assert.assertNotNull((Object)descRP.getPublisherReference());
        EndpointReferenceType publisherRef = descRP.getPublisherReference();
        Assert.assertEquals((String)DEFAULT_PETALS_ADDRESS, (String)publisherRef.getAddress());
        System.out.println(publisherRef.getAddress());
        ReferenceParametersType refParams = (ReferenceParametersType)publisherRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParams);
        List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParams).getModel()).getAny();
        System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
        Assert.assertNotNull((Object)descRP.getTopic());
        List topics = descRP.getTopic();
        System.out.println("Topic list :");
        for (TopicExpressionType topic : topics) {
            System.out.println("~~~~~~ ");
            System.out.println(topic.getDialect());
            System.out.println(topic.getTopicNameSpace());
            System.out.println(topic.getContent());
            System.out.println("~~~~~~ ");
        }
    }

    public void testWriterRegisterPublisher() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterRegisterPublisher() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/RegisterPublisher.xml"));
        RegisterPublisher regPub = WSNotificationReader.getInstance().readRegisterPublisher(docDesc);
        Assert.assertNotNull((Object)regPub);
        Document docWrotten = WSNotificationWriter.getInstance().writeRegisterPublisher(regPub);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteRegisterPublisher() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRegisterPublisher() throws URISyntaxException, WSNotificationException, WSAddressingException {
        RegisterPublisher registerPublisherPayload = WSNotificationFactory.getInstance().createRegisterPublisher();
        registerPublisherPayload.setDemand(Boolean.valueOf(true));
        GregorianCalendar gCalendar = new GregorianCalendar();
        registerPublisherPayload.setInitialTerminationTime(gCalendar.getTime());
        EndpointReferenceType producerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        producerEdpRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)producerEdpRef.newReferenceParameters();
        producerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        registerPublisherPayload.setPublisherReference(producerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        registerPublisherPayload.addTopic(topic);
        Assert.assertNotNull((Object)registerPublisherPayload);
        Document doc = WSNotificationWriter.getInstance().writeRegisterPublisher(registerPublisherPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateRegisterPublisher() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadRegisterPublisherResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/RegisterPublisherResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadRegisterPublisherResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        RegisterPublisherResponse descRPResp = WSNotificationReader.getInstance().readRegisterPublisherResponse(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check RegisterPublisherResponse attributs value : \n ");
        Assert.assertNotNull((Object)descRPResp);
        EndpointReferenceType registrationRef = descRPResp.getPublisherRegistrationReference();
        Assert.assertNotNull((Object)registrationRef);
        System.out.println(registrationRef.getAddress());
        ReferenceParametersType refParams = (ReferenceParametersType)registrationRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParams);
        List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParams).getModel()).getAny();
        System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
    }

    public void testWriterRegisterPublisherResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/RegisterPublisherResponse.xml"));
        RegisterPublisherResponse descRead = WSNotificationReader.getInstance().readRegisterPublisherResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeRegisterPublisherResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteRegisterPublisherResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRegisterPublisherResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        RegisterPublisherResponse registerPublisherResponsePayload = WSNotificationFactory.getInstance().createRegisterPublisherResponse();
        EndpointReferenceType registrationRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        registrationRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)registrationRef.newReferenceParameters();
        registrationRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        registerPublisherResponsePayload.setPublisherRegistrationReference(registrationRef);
        Assert.assertNotNull((Object)registerPublisherResponsePayload);
        Document doc = WSNotificationWriter.getInstance().writeRegisterPublisherResponse(registerPublisherResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateRegisterPublisherResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadDestroyRegistration() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/DestroyRegistration.xml"));
        System.out.println("\n\t ========== \n \n testReadDestroyRegistration() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration descDestReg = WSNotificationReader.getInstance().readDestroyRegistration(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check DestroyRegistration attributs value : \n ");
        Assert.assertNotNull((Object)descDestReg);
        List listOfObj = ((DestroyRegistration)((AbstractSchemaElementImpl)descDestReg).getModel()).getAny();
        System.out.println("DestroyRegistration content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
    }

    public void testWriterDestroyRegistration() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/DestroyRegistration.xml"));
        com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration descRead = WSNotificationReader.getInstance().readDestroyRegistration(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeDestroyRegistration(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteDestroyRegistration() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateDestroyRegistration() throws URISyntaxException, WSNotificationException, WSAddressingException {
        com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration destroyRegistrationPayload = WSNotificationFactory.getInstance().createDestroyRegistration();
        EndpointReferenceType edpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        edpRef.setAddress("mail-address-sample@ebmwebsourcing.com");
        ReferenceParametersType refParam = (ReferenceParametersType)edpRef.newReferenceParameters();
        edpRef.setReferenceParameters((AbsItfReferenceParametersType)refParam);
        Document doc = WSNotificationWriter.getInstance().writeDestroyRegistration(destroyRegistrationPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateDestroyRegistration() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadDestroyRegistrationResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/DestroyRegistrationResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadDestroyRegistrationResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        System.out.println("\n ~~~ \n");
        System.out.println("Check DestroyRegistrationResponse attributs value : \n ");
        DestroyRegistrationResponse descDestReg = WSNotificationReader.getInstance().readDestroyRegistrationResponse(docDesc);
        Assert.assertNotNull((Object)descDestReg);
    }

    public void testWriterDestroyRegistrationResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinition.class.getResourceAsStream("/descriptors/DestroyRegistrationResponse.xml"));
        DestroyRegistrationResponse descRead = WSNotificationReader.getInstance().readDestroyRegistrationResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeDestroyRegistrationResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteDestroyRegistrationResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateDestroyRegistrationResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        DestroyRegistrationResponse destroyRegistrationRepsonsePayload = WSNotificationFactory.getInstance().createDestroyRegistrationResponse();
        Document doc = WSNotificationWriter.getInstance().writeDestroyRegistrationResponse(destroyRegistrationRepsonsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateDestroyRegistrationResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testPersistAndRestorePublisherRegistrationRP() {
        try {
            File[] storedRegFiles;
            String tempDirName = "tmp" + File.separatorChar;
            String persistenceRepositoryName = tempDirName + "SavePublisherRegistrationRP" + File.separatorChar;
            File persistenceRepository = new File(persistenceRepositoryName);
            persistenceRepository.mkdirs();
            Document request = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/RegisterPublisher.xml"));
            RegisterPublisher regPayload = WSNotificationReader.getInstance().readRegisterPublisher(request);
            PublisherRegistrationRP registrationToPersist = WSNotificationFactory.getInstance().createPublisherRegistrationRP();
            registrationToPersist.setPublisherReference(regPayload.getPublisherReference());
            List topics = regPayload.getTopic();
            for (TopicExpressionType topExpItem : topics) {
                registrationToPersist.addTopic(topExpItem);
            }
            registrationToPersist.setDemand(regPayload.isDemand());
            int nbOfReg = new Random().nextInt(5) + 1;
            System.out.println("[INFO : generate " + nbOfReg + " registration to store)");
            for (int i = 0; i < nbOfReg; ++i) {
                registrationToPersist.setCreationTime(new GregorianCalendar().getTime());
                File fileToSaveTo = new File(persistenceRepositoryName + UUID.randomUUID());
                WSNotificationWriter.getInstance().writePublisherRegistrationRP(registrationToPersist, fileToSaveTo);
            }
            if (persistenceRepository.exists() && persistenceRepository.isDirectory()) {
                File[] persistedSubscriptions = persistenceRepository.listFiles();
                Document docRep = null;
                System.out.println(" ########### Liste des Registration restaur\u00e9es : ###########");
                for (int i = 0; i < persistedSubscriptions.length; ++i) {
                    docRep = Util.fromFileTodocument(persistedSubscriptions[i]);
                    System.out.println(" ########## Restored Subscription " + persistedSubscriptions[i].getName() + ":\n\n" + XMLPrettyPrinter.prettyPrint((Document)docRep) + "\n");
                }
                System.out.println(" ########### Fin de List  ###########");
            }
            for (File fileItem : storedRegFiles = persistenceRepository.listFiles()) {
                fileItem.delete();
            }
            persistenceRepository.delete();
            new File(tempDirName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

