/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.definition.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.test.TestWSBaseNotificationDefinition;
import com.ebmwebsourcing.wsstar.notification.definition.test.Util;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.net.URISyntaxException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestWSTopicDefinition
extends TestCase {
    public void testReadTopicNamespace() throws URISyntaxException, WSNotificationException, WSAddressingException {
        System.out.println("\n\t testReadTopicNamespace() method outputs :\n");
        Document docDesc = Util.convertFromUriToDocument(TestWSTopicDefinition.class.getResource("/topicNamespace/wsdm-mows-events.xml").toURI());
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        TopicNamespaceType descTN = WSNotificationReader.getInstance().readTopicNamespaceType(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check TopicNamespace attributs value : \n ");
        Assert.assertNotNull((Object)descTN);
        Assert.assertEquals((int)descTN.getTopics().size(), (int)7);
    }

    private void recursiveTopicDisplay(TopicType topic, List<TopicType> children) {
        if (children != null) {
            for (TopicType child : children) {
                System.out.println("topic name : " + child.getName() + " (child topic of " + topic.getName() + ")");
                this.recursiveTopicDisplay(child, child.getChildren());
            }
        } else {
            System.out.println("no children for the topic : " + topic.getName());
        }
    }

    public void testReadSimpleTopicNamespace() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/TopicNamespace.xml"));
        System.out.println("\n\t ========== \n \n testReadTopicNamespace() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        TopicNamespaceType descTopicNS = WSNotificationReader.getInstance().readTopicNamespaceType(docDesc);
        Assert.assertNotNull((Object)descTopicNS);
        System.out.println("TopicNamespace  name : " + descTopicNS.getName());
        System.out.println("TopicNamespace  target namespace : " + descTopicNS.getTargetNamespace());
        List listOfTopics = descTopicNS.getTopics();
        Assert.assertNotNull((Object)listOfTopics);
        for (TopicType topic : listOfTopics) {
            System.out.println("topic name : " + topic.getName() + " (root topic)");
            this.recursiveTopicDisplay(topic, topic.getChildren());
        }
    }

    public void testWriterSimpleTopicNamespace() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/TopicNamespace.xml"));
        TopicNamespaceType descRead = WSNotificationReader.getInstance().readTopicNamespaceType(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeTopicNamespaceType(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteTopicNamespace() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSimpleTopicNamespace() throws URISyntaxException, WSNotificationException, WSAddressingException {
        TopicNamespaceType topicNS = WSNotificationFactory.getInstance().createTopicNamespaceType();
        topicNS.setName("MyTopicNamespaceSample");
        topicNS.setTargetNamespace("http://petals.ow2.org/topicNamespace/MyTopicNamespaceSample");
        TopicType rootTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        rootTopic1ToAdd.setName("rootTopic1");
        TopicType rootTopic2ToAdd = WSNotificationFactory.getInstance().createTopicType();
        rootTopic2ToAdd.setName("rootTopic2");
        TopicType childTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childTopic1ToAdd.setName("ChildTopic1");
        TopicType childTopic2ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childTopic2ToAdd.setName("ChildTopic2");
        TopicType childChildTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic1ToAdd.setName("childChildTopic1");
        TopicType childChildTopic2ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic2ToAdd.setName("childChildTopic2");
        TopicType childChildTopic3ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic3ToAdd.setName("childChildTopic3");
        childTopic1ToAdd.addTopicChild(childChildTopic1ToAdd);
        childTopic1ToAdd.addTopicChild(childChildTopic2ToAdd);
        childTopic2ToAdd.addTopicChild(childChildTopic3ToAdd);
        rootTopic1ToAdd.addTopicChild(childTopic1ToAdd);
        rootTopic2ToAdd.addTopicChild(childTopic2ToAdd);
        topicNS.addTopic(rootTopic1ToAdd);
        topicNS.addTopic(rootTopic2ToAdd);
        Document doc = WSNotificationWriter.getInstance().writeTopicNamespaceType(topicNS);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateTopicNamespace() - created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadSimpleTopicType() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Topic.xml"));
        System.out.println("\n\t ========== \n \n testReadTopicType() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        TopicType descTopic = WSNotificationReader.getInstance().readTopicType(docDesc);
        Assert.assertNotNull((Object)descTopic);
        System.out.println("Topic  name : " + descTopic.getName());
        List listOfTopics = descTopic.getChildren();
        Assert.assertNotNull((Object)listOfTopics);
        for (TopicType topic : listOfTopics) {
            System.out.println("topic name : " + topic.getName() + " (root topic)");
            this.recursiveTopicDisplay(topic, topic.getChildren());
        }
    }

    public void testWriterSimpleTopicType() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Topic.xml"));
        TopicType descRead = WSNotificationReader.getInstance().readTopicType(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeTopicType(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteTopicType() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateTopicType() throws URISyntaxException, WSNotificationException, WSAddressingException {
        TopicType rootTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        rootTopic1ToAdd.setName("rootTopic1");
        TopicType childTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childTopic1ToAdd.setName("ChildTopic1");
        TopicType childTopic2ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childTopic2ToAdd.setName("ChildTopic2");
        TopicType childChildTopic1ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic1ToAdd.setName("childChildTopic1");
        TopicType childChildTopic2ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic2ToAdd.setName("childChildTopic2");
        TopicType childChildTopic3ToAdd = WSNotificationFactory.getInstance().createTopicType();
        childChildTopic3ToAdd.setName("childChildTopic3");
        childTopic1ToAdd.addTopicChild(childChildTopic1ToAdd);
        childTopic1ToAdd.addTopicChild(childChildTopic2ToAdd);
        childTopic2ToAdd.addTopicChild(childChildTopic3ToAdd);
        rootTopic1ToAdd.addTopicChild(childTopic1ToAdd);
        rootTopic1ToAdd.addTopicChild(childTopic2ToAdd);
        Document doc = WSNotificationWriter.getInstance().writeTopicType(rootTopic1ToAdd);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateTopicType() - created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }
}

