package com.ebmwebsourcing.wsaddressing10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.AttributedURIType;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;

import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;


class EndpointReferenceTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbEndpointReferenceType> implements
EndpointReferenceType {

    protected EndpointReferenceTypeImpl(XmlContext xmlContext, EJaxbEndpointReferenceType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbEndpointReferenceType> getCompliantModelClass() {
		return EJaxbEndpointReferenceType.class;
	}


	@Override
	public Address getAddress() {
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getAddress(), Address.class);
	}


	@Override
	public boolean hasAddress() {
		return this.getAddress() != null;
	}


	@Override
	public void setAddress(Address value) {
		if(value != null) {
			getModelObject().setAddress(((AttributedURITypeImpl)((AttributedURIType) value)).getModelObject());
		} else {
			getModelObject().setAddress(null);
		}
	}


	@Override
	public ReferenceParameters getReferenceParameters() {
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getReferenceParameters(), ReferenceParameters.class);
	}


	@Override
	public void setReferenceParameters(ReferenceParameters value) {
		if(value != null) {
			getModelObject().setReferenceParameters(((ReferenceParametersTypeImpl)((ReferenceParameters) value)).getModelObject());
		} else {
			getModelObject().setReferenceParameters(null);
		}
	}


	@Override
	public boolean hasReferenceParameters() {
		return this.getReferenceParameters() != null;
	}

}
