package com.ebmwebsourcing.wsdm10.impl;



import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsdm10.api.type.IntegerCounter;

import easybox.org.oasis_open.docs.wsdm.mows_2.EJaxbIntegerCounter;


class IntegerCounterImpl extends AbstractJaxbXmlObjectImpl<EJaxbIntegerCounter> implements IntegerCounter {

	IntegerCounterImpl(XmlContext xmlContext, EJaxbIntegerCounter jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbIntegerCounter> getCompliantModelClass() {
		return EJaxbIntegerCounter.class;
	}


	@Override
	public Long getValue() {
		if(this.getModelObject().getValue() != null) {
			return this.getModelObject().getValue().longValue();
		}
		return null;
	}


	@Override
	public void setValue(Long value) {
		if(value != null) {
			this.getModelObject().setValue(BigInteger.valueOf(value));
		} else {
			this.getModelObject().setValue(null);
		}
	}


	@Override
	public boolean hasValue() {
		return this.getValue() != null;
	}


	@Override
	public Date getResetAt() {
		if(this.getModelObject().getResetAt() != null) {
			return this.getModelObject().getResetAt().toGregorianCalendar().getTime();
		}
		return null;
	}


	@Override
	public void setResetAt(Date value) {
		if (value != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(value);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.getModelObject().setResetAt(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new RuntimeException(e);
			}
		} else {
			this.getModelObject().setResetAt(null);
		}
	}


	@Override
	public boolean hasResetAt() {
		return this.getResetAt() != null;
	}


	@Override
	public Date getLastUpdated() {
		if(this.getModelObject().getLastUpdated() != null) {
			return this.getModelObject().getLastUpdated().toGregorianCalendar().getTime();
		}
		return null;
	}


	@Override
	public void setLastUpdated(Date value) {
		if (value != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(value);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.getModelObject().setLastUpdated(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new RuntimeException(e);
			}
		} else {
			this.getModelObject().setLastUpdated(null);
		}
	}


	@Override
	public boolean hasLastUpdated() {
		return this.getLastUpdated() != null;
	}


	@Override
	public Duration getDuration() {
		return this.getModelObject().getDuration();
	}


	@Override
	public void setDuration(Duration value) {
		this.getModelObject().setDuration(value);
	}


	@Override
	public boolean hasDuration() {
		return this.getDuration() != null;
	}


	@Override
	public Map<QName, String> getOtherAttributes() {
		return this.getModelObject().getOtherAttributes();
	}




}
