/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.collaborateur;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.persistence.bo.collaborateur.AppartientCollegeIdP;
import org.jeinnov.jeitime.persistence.bo.collaborateur.AppartientCollegeP;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollegeP;
import org.jeinnov.jeitime.persistence.dao.collaborateur.AppartientCollegeDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class AppartientCollegeManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private AppartientCollegeDAO appartientCollegeDAO = AppartientCollegeDAO.getInstance();
    private static AppartientCollegeManager manager;

    public static AppartientCollegeManager getInstance() {
        if (manager == null) {
            manager = new AppartientCollegeManager();
        }
        return manager;
    }

    public int get(int idCollaborateur) {
        AppartientCollegeP aCP = new AppartientCollegeP();
        int idCollege = 0;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            aCP = this.appartientCollegeDAO.getByIdCollaborateur(idCollaborateur);
            idCollege = aCP != null ? aCP.getCollege().getIdCollege() : 0;
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return idCollege;
    }

    public void saveOrUpdate(int idCollege, int idCollaborateur) throws CollaborateurException {
        if (idCollaborateur == 0 || idCollege == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier une coll\u00e8ge et un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listACP = this.appartientCollegeDAO.getAllByIdCollaborateur(idCollaborateur);
            if (listACP != null) {
                for (AppartientCollegeP aCP : listACP) {
                    this.appartientCollegeDAO.remove((Object)aCP);
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            Date date = cal.getTime();
            AppartientCollegeIdP idLiaison = new AppartientCollegeIdP(idCollege, idCollaborateur, date);
            CollaborateurP collaborateur = new CollaborateurP(idCollaborateur);
            CollegeP college = new CollegeP(idCollege);
            AppartientCollegeP liaisonCollegeColla = new AppartientCollegeP();
            liaisonCollegeColla.setCollaborateur(collaborateur);
            liaisonCollegeColla.setCollege(college);
            liaisonCollegeColla.setId(idLiaison);
            this.appartientCollegeDAO.save((Object)liaisonCollegeColla);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteByIdCollaborateur(int idCollaborateur) throws CollaborateurException {
        if (idCollaborateur == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listACP = this.appartientCollegeDAO.getAllByIdCollaborateur(idCollaborateur);
            if (listACP != null) {
                for (AppartientCollegeP aCP : listACP) {
                    this.appartientCollegeDAO.remove((Object)aCP);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteByIdCollege(int idCollege) throws CollaborateurException {
        if (idCollege == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un coll\u00e8ge !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listACP = this.appartientCollegeDAO.getAllByIdCollege(idCollege);
            if (listACP != null) {
                for (AppartientCollegeP aCP : listACP) {
                    this.appartientCollegeDAO.remove((Object)aCP);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

