/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.heure;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.heure.HeureException;
import org.jeinnov.jeitime.api.service.utils.InsertionSousTotaux;
import org.jeinnov.jeitime.api.service.utils.SortList;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.heure.SaisieHeureTO;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.jeinnov.jeitime.persistence.bo.projet.LienTachUtilP;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.dao.heure.LienTacheUtilDAO;
import org.jeinnov.jeitime.persistence.dao.projet.TacheDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class ConsultationMensuelleManager
extends InsertionSousTotaux {
    private SortList sortList = new SortList();
    private final Logger logger = Logger.getLogger(this.getClass());
    private static ConsultationMensuelleManager manager;

    public static ConsultationMensuelleManager getInstance() {
        if (manager == null) {
            manager = new ConsultationMensuelleManager();
        }
        return manager;
    }

    public List<SaisieHeureTO> afficheListSaisieAllC(int idColl, Date dateD, Date dateF) throws HeureException {
        if (idColl == 0) {
            throw new HeureException("Attention aucun collaborateur n'est rattach\u00e9 !");
        }
        if (dateD == null || dateF == null) {
            throw new HeureException("Attention la date de d\u00e9but ou la date de fin ne sont pas renseign\u00e9es");
        }
        Timestamp timeDeb = new Timestamp(dateD.getTime());
        Timestamp timeFin = new Timestamp(dateF.getTime());
        ArrayList<SaisieHeureTO> tablSaisie = new ArrayList<SaisieHeureTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listLien = LienTacheUtilDAO.getInstance().getAllByIdCollaborateurAndStartDateAndEndDate(idColl, timeDeb, timeFin);
            if (listLien == null || listLien.isEmpty()) {
                this.createSaisieHeure(idColl, tablSaisie, (org.hibernate.Session)session);
            } else {
                for (int i = 0; i < listLien.size(); ++i) {
                    int idTach = ((LienTachUtilP)listLien.get(i)).getTache().getIdTache();
                    TacheP tacheP = (TacheP)TacheDAO.getInstance().find((Serializable)Integer.valueOf(idTach));
                    ProjetTO projet = new ProjetTO(tacheP.getProjet().getIdProjet(), tacheP.getProjet().getNomProjet());
                    CollaborateurTO collab = new CollaborateurTO();
                    collab.setIdColl(((LienTachUtilP)listLien.get(i)).getCollaborateur().getIdColl());
                    collab.setNomColl(((LienTachUtilP)listLien.get(i)).getCollaborateur().getNomColl());
                    collab.setPrenomColl(((LienTachUtilP)listLien.get(i)).getCollaborateur().getPrenomColl());
                    TypeTacheTO typeTache = new TypeTacheTO(((LienTachUtilP)listLien.get(i)).getTache().getNomTacheP().getTypeTache().getIdTypeTache());
                    NomTacheTO nomTache = new NomTacheTO(((LienTachUtilP)listLien.get(i)).getTache().getNomTacheP().getIdNomTache(), ((LienTachUtilP)listLien.get(i)).getTache().getNomTacheP().getNomTache(), typeTache);
                    TacheTO tache = new TacheTO(((LienTachUtilP)listLien.get(i)).getTache().getIdTache(), nomTache);
                    Date dateS = ((LienTachUtilP)listLien.get(i)).getId().getDate();
                    float nbheure = ((LienTachUtilP)listLien.get(i)).getNbHeure();
                    String commentaire = ((LienTachUtilP)listLien.get(i)).getCommentaire();
                    SaisieHeureTO saisieH = new SaisieHeureTO(tache, projet, collab, dateS, nbheure, commentaire);
                    tablSaisie.add(saisieH);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Collections.sort(tablSaisie);
        return tablSaisie;
    }

    private void createSaisieHeure(int idColl, List<SaisieHeureTO> tablSaisie, org.hibernate.Session session) {
        SaisieHeureTO saisieH = new SaisieHeureTO();
        CollaborateurP c = (CollaborateurP)session.load(CollaborateurP.class, (Serializable)Integer.valueOf(idColl));
        CollaborateurTO cTO = new CollaborateurTO();
        cTO.setIdColl(c.getIdColl());
        cTO.setNomColl(c.getNomColl());
        cTO.setPrenomColl(c.getPrenomColl());
        Date d = null;
        TacheTO t = new TacheTO();
        t.setIdTache(0);
        ProjetTO p = new ProjetTO();
        p.setIdProjet(0);
        saisieH.setCollab(cTO);
        saisieH.setNbHeure(0.0f);
        saisieH.setSaisiDate(d);
        saisieH.setCommentaire(null);
        saisieH.setProjet(p);
        saisieH.setTache(t);
        tablSaisie.add(saisieH);
    }

    public List<Object> listSaisieAllCollab(List<SaisieHeureTO> tablSaisie) throws HeureException {
        if (tablSaisie == null) {
            throw new HeureException("Attention aucune saisie n'est s\u00e9lectionn\u00e9e");
        }
        int id = 0;
        ArrayList<Object> listItems = new ArrayList<Object>();
        for (int i = 0; i < tablSaisie.size(); ++i) {
            this.creerListItems(tablSaisie, listItems, i);
            id = tablSaisie.get(i).getCollab().getIdColl();
        }
        this.sortList.sortListItems(listItems);
        this.sortList.sortListByTacheTO(listItems);
        this.sortList.sortListByCollaborateurTO(listItems);
        if (id != 0) {
            listItems.add(id);
        }
        return listItems;
    }

    private void creerListItems(List<SaisieHeureTO> tablSaisie, List<Object> listItems, int i) {
        if (tablSaisie.get(i).getTache().getIdTache() == 0) {
            CollaborateurTO c = new CollaborateurTO();
            c.setIdColl(tablSaisie.get(i).getCollab().getIdColl());
            c.setNomColl(tablSaisie.get(i).getCollab().getNomColl());
            c.setPrenomColl(tablSaisie.get(i).getCollab().getPrenomColl());
            c.setEquipe(tablSaisie.get(i).getCollab().getEquipe());
            listItems.add(c);
        } else {
            CollaborateurTO c = new CollaborateurTO();
            c.setIdColl(tablSaisie.get(i).getCollab().getIdColl());
            c.setNomColl(tablSaisie.get(i).getCollab().getNomColl());
            c.setPrenomColl(tablSaisie.get(i).getCollab().getPrenomColl());
            c.setEquipe(tablSaisie.get(i).getCollab().getEquipe());
            listItems.add(c);
            String nomProjet = tablSaisie.get(i).getProjet().getNomProjet();
            listItems.add(nomProjet);
            TacheTO t = new TacheTO();
            t.setIdTache(tablSaisie.get(i).getTache().getIdTache());
            t.setNomtache(tablSaisie.get(i).getTache().getNomtache());
            t.setPriorite(tablSaisie.get(i).getCollab().getIdColl());
            t.setEligible(tablSaisie.get(i).getTache().isEligible());
            t.setProjet(tablSaisie.get(i).getProjet());
            listItems.add(t);
        }
    }
}

