/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.DomaineTO;
import org.jeinnov.jeitime.persistence.bo.projet.DomaineP;
import org.jeinnov.jeitime.persistence.dao.projet.DomaineDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class DomaineManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private DomaineDAO domaineDAO = DomaineDAO.getInstance();
    private static DomaineManager manager;

    public static DomaineManager getInstance() {
        if (manager == null) {
            manager = new DomaineManager();
        }
        return manager;
    }

    public DomaineTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun domaine n'est s\u00e9lectionn\u00e9");
        }
        DomaineTO domTO = new DomaineTO();
        DomaineP domP = new DomaineP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            domP = (DomaineP)this.domaineDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (domP == null) {
            throw new ProjetException("Attention aucun domaine avec cet identifiant existe en base !");
        }
        domTO.setIdDomaine(domP.getIdDomaine());
        domTO.setNomDomaine(domP.getNomDomaine());
        return domTO;
    }

    public List<DomaineTO> getAll() {
        ArrayList<DomaineTO> allDomTO = new ArrayList<DomaineTO>();
        List allDom = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            allDom = this.domaineDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (allDom != null) {
            for (DomaineP dom : allDom) {
                DomaineTO domTO = new DomaineTO();
                domTO.setIdDomaine(dom.getIdDomaine());
                domTO.setNomDomaine(dom.getNomDomaine());
                allDomTO.add(domTO);
            }
        }
        return allDomTO;
    }

    public int saveOrUpdate(DomaineTO domTO) throws ProjetException {
        if (domTO == null) {
            throw new ProjetException("Attention aucun domaine n'est s\u00e9lectionn\u00e9");
        }
        if (domTO.getNomDomaine() == null) {
            throw new ProjetException("Attention aucun nom n'a \u00e9t\u00e9 donn\u00e9 au domaine ");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        DomaineP dom = new DomaineP();
        dom = this.domaineDAO.getByName(domTO.getNomDomaine());
        this.verificationAvantEnregistrement(domTO, dom);
        if (dom == null || dom.getIdDomaine() == 0) {
            dom = new DomaineP();
        }
        dom.setIdDomaine(domTO.getIdDomaine());
        dom.setNomDomaine(domTO.getNomDomaine());
        try {
            this.domaineDAO.save((Object)dom);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return dom.getIdDomaine();
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun domaine n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            DomaineP domP = (DomaineP)this.domaineDAO.find((Serializable)Integer.valueOf(id));
            if (domP == null || domP.getIdDomaine() == 0) {
                throw new ProjetException("Attention aucun domaine avec cet identifiant existe en base !");
            }
            this.domaineDAO.remove((Object)domP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun domaine n'est s\u00e9lectionn\u00e9");
        }
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.domaineDAO.isInProject(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(DomaineTO dTO, DomaineP dP) throws ProjetException {
        if (dP != null && dP.getIdDomaine() != dTO.getIdDomaine()) {
            throw new ProjetException("Attention, un domaine avec ce nom existe d\u00e9j\u00e0 !");
        }
    }
}

